<?php
/**
 * MTS Car Booking 車両データ管理のビュー
 *
 * @Filename    RoomAdminView.php
 * @Author      S.Hayashi
 * @Code        2016-11-11 Ver.1.0.0
 */
namespace MTSCarBookingTrial\views;

use MTSCarBookingTrial\Config;
use MTSCarBookingTrial\CustomPost;
use MTSCarBookingTrial\ChargeAdmin;
use MTSCarBookingTrial\VehicleAdmin;
use MTSCarBookingTrial\models\Vehicle;
use MTSCarBookingTrial\models\Charge;

class VehicleAdminView
{
    const PAGE_NAME = VehicleAdmin::PAGE_NAME;

    const JS = 'js/vehicle-admin.js';
    const CSS = 'css/mtsrcb-admin.css';
    //const UI_CSS = '://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/smoothness/jquery-ui.css';
    //const LOADING_GIF = "img/ajax-loaderf.gif";


    private $oHelper = null;

    /**
     * constructor
     */
    public function __construct(Vehicle $oVehicle)
    {
        $this->oHelper = FormHelper::getInstance();

        // JavaScript、CSSソースの読み込み指定
        add_action('admin_enqueue_scripts', array($this, 'enqueueScript'));
        //add_action("admin_print_footer_scripts", array($this, 'enqueueData'));

        // 管理画面追加編集ブロック登録
        $idname = self::PAGE_NAME . '-';
        add_meta_box("{$idname}name", '車両名称', array($this, 'nameBox'), CustomPost::VEHICLE, 'normal', 'default', array('oVehicle' => $oVehicle));
        add_meta_box("{$idname}registry", '車両登録情報', array($this, 'registryBox'), CustomPost::VEHICLE, 'normal', 'default', array('oVehicle' => $oVehicle));
        add_meta_box("{$idname}charge", '料金', array($this, 'chargeBox'), CustomPost::VEHICLE, 'normal', 'default', array('oVehicle' => $oVehicle));
        add_meta_box("{$idname}detail", '車両情報詳細', array($this, 'detailBox'), CustomPost::VEHICLE, 'normal', 'default', array('oVehicle' => $oVehicle));
        add_meta_box("{$idname}image", '車両画像', array($this, 'imageBox'), CustomPost::VEHICLE, 'normal', 'default', array('oVehicle' => $oVehicle));
    }

    /**
     * CSS、JavaScriptのロード登録
     */
    public function enqueueScript()
    {
        //$uiCss = sprintf('http%s%s', (preg_match('/^https:/', admin_url()) ? 's' : ''), self::UI_CSS);

        $dir = dirname(__FILE__);
        wp_enqueue_script(self::PAGE_NAME, plugins_url(self::JS, $dir), array('jquery'));//, 'jquery-ui-dialog'));
        wp_enqueue_media();

        wp_enqueue_style(self::PAGE_NAME, plugins_url(self::CSS, $dir));
        //wp_enqueue_style(self::PAGE_NAME . '-cdn', $uiCss);

    }

    /**
     * JavaScript定義データ挿入
     */
/*
    public function enqueueData()
    {
        echo "<script type='text/javascript'>\n";
        echo 'var mtsab_langs = ' . json_encode(DataResource::$language) . ';';
        echo "\n</script>";
    }
*/
    /**
     * 車両名称
     */
    public function nameBox($oPost, $meta)
    {
        $oVehicle = $meta['args']['oVehicle'];

        foreach (Config::$languages as $lang => $title) {
            echo '<div class="line-box">';
            echo sprintf('<label for="name-%s" class="lang-title">%s</label>', $lang, $title);
            //echo sprintf('<input id="name-%s" class="mts-middle" type="text" name="vehicle[name][%s]" value="%s">', $lang, $lang, $oVehicle->name->$lang);
            echo $this->oHelper->textBox("name-{$lang}", 'mts-middle', "vehicle[name][{$lang}]", (property_exists($oVehicle->name, $lang) ? $oVehicle->name->$lang : ''));
            echo "</div>\n";
        }

        echo sprintf('<input type="hidden" name="vehicle_nonce" value="%s">', wp_create_nonce(self::PAGE_NAME));
    }

    /**
     * 登録情報の編集
     */
    public function registryBox($oPost, $meta)
    {
        $oVehicle = $meta['args']['oVehicle'];

        $ymd = ['', '', ''];
        $gengo = 'seireki';

        if ($oVehicle->expiration != '') {
            $ymd = explode('-', $oVehicle->expiration);
            $gengo = $this->oHelper->getGengo($oVehicle->expiration);
            $ymd[0] = $this->oHelper->getNengo($oVehicle->expiration, $gengo);
            array_walk($ymd, function(&$val, $key) {
                $val = intval($val);
            });
        }

?>
     <table class="mts-form-table">
         <tr>
             <th>ナンバー</th>
             <td>
                 <div class="number-box">
                     <label for="number-region">地域名</label>
                     <input id="number-region" class="mts-fat" type="text" name="vehicle[number][region]" value="<?php echo $oVehicle->number->region ?>">
                 </div>
                 <div class="number-box">
                     <label for="number-class">分類番号</label>
                     <input id="number-class" class="mts-fat" type="text" name="vehicle[number][class]" value="<?php echo $oVehicle->number->class ?>">
                 </div>
                 <div class="number-box">
                     <label for="number-kana">平仮名</label>
                     <input id="number-kana" class="mts-fat" type="text" name="vehicle[number][kana]" value="<?php echo $oVehicle->number->kana ?>">
                 </div>
                 <div class="number-box">
                     <label for="number-designation">一連指定番号</label>
                     <input id="number-designation" class="mts-fat" type="text" name="vehicle[number][designation]" value="<?php echo $oVehicle->number->designation ?>">
                 </div>
             </td>
         </tr>
         <tr class="mts-v-middle">
             <th>有効期限満了日</th>
             <td>
                 <?php echo $this->oHelper->selectGengo('expiration-gengo', '', 'vehicle[expiration][gengo]', $gengo);
                    echo $this->oHelper->textBox('expiration-year', 'mts-char4 mts-center', 'vehicle[expiration][year]', $ymd[0], '年');
                    echo $this->oHelper->textBox('expiration-month', 'mts-char4 mts-center', "vehicle[expiration][month]", $ymd[1], '月');
                    echo $this->oHelper->textBox('expiration-day', 'mts-char4 mts-center', "vehicle[expiration][day]", $ymd[2], '日');
                    echo sprintf('<div class="expiaration-seireki">西暦：%s', $oVehicle->expiration); ?>
             </td>
         </tr>
     </table>

<?php
    }

    /**
     * 料金
     */
    public function chargeBox($oPost, $meta)
    {
        $oVehicle = $meta['args']['oVehicle'];

        $list = ChargeAdmin::listCharge(Charge::VEHICLE);
        $list += array(0 => '----')

?>
        <table class="mts-form-table">
            <tr>
                <th>料金表</th>
                <td>
                    <?php echo $this->oHelper->selectBox('charge-table', '', 'vehicle[charge][charge_id]', $list, $oVehicle->charge->charge_id) ?>
                </td>
            </tr>
            <tr>
                <th>燃料</th>
                <td>
                    <?php echo $this->oHelper->selectBox('charge-fuel', '', 'vehicle[charge][fuel]', ParamAdmin::$fuelType, $oVehicle->charge->fuel) ?>
                </td>
            </tr>
            <tr>
                <th>燃費</th>
                <td>
                    <?php echo $this->oHelper->textBox('charge-fuel-km', 'mts-small-number', 'vehicle[charge][fuel_km]', $oVehicle->charge->fuel_km, 'km/l') ?>
                </td>
            </tr>
        </table>

<?php
    }

    /**
     * 車両情報詳細の編集
     */
    public function detailBox($oPost, $meta)
    {
        $oVehicle = $meta['args']['oVehicle'];
        $detail = $oVehicle->detail;
        $items = ParamAdmin::$vehicleDetail;

?>
        <table class="mts-form-table"><?php foreach ($items as $item => $title) : ?>

            <tr>
                <th><?php echo $title ?></th>
                <td>
                    <?php echo $this->oHelper->textBox("detail-{$item}", 'mts-middle', "vehicle[detail][{$item}]", (property_exists($oVehicle->detail, $item) ? $oVehicle->detail->$item : '')) ?>
                </td>
            </tr><?php endforeach; ?>

        </table>

<?php
    }

    /**
     * 車両画像の設定
     */
    public function imageBox($oPost, $meta)
    {
        $oVehicle = $meta['args']['oVehicle'];

        echo '<table id="vehicle-image" class="image-box">' . "\n";

        for ($i = 0; $i < Vehicle::NUMBER_OF_IMAGES; $i++) :
            $url = isset($oVehicle->image[$i]) ? $oVehicle->image[$i] : '';
?>
        <tr class="image-tr">
            <td class="car-thumbnail">
                <img class="car-image" src="<?php echo $url ?>">
            </td>
            <td>
                <input type="text" class="image-url" name="vehicle[image][]" value="<?php echo $url ?>">
                <input type="button" class="button" value="メディアライブラリから選択" onclick="mtsrcb_vehicle_admin.select(<?php echo $i ?>)">
                <input type="button" class="button" value="クリア" onclick="mtsrcb_vehicle_admin.clear(<?php echo $i ?>)">
            </td>
        </tr>

<?php
        endfor;
        echo "</table>\n";

    }




}
