<?php
/**
 * MTS Car Booking フロントエンド予約カレンダービュー
 *
 * @Filename    BookingCalendarView.php
 * @Author      S.Hayashi
 * @Code        2018-10-16 Ver.1.0.0
 */
namespace MTSCarBookingTrial\views;

use MTSCarBookingTrial\Config;
use MTSCarBookingTrial\lang\Translation;
use MTSCarBookingTrial\models\Calendar;


class BookingCalendarView extends CalendarView
{
    private $oCalendar = null;      // カレンダー条件
    private $rentals = array();     // データ

    /**
     * Constructor
     */
    public function __construct(Calendar $oCalendar, $rentals, $lang)
    {
        parent::__construct();

        $this->oCalendar = $oCalendar;
        $this->rentals = $rentals;
        $this->lang = $lang;
    }

    /**
     * 1カ月カレンダーのHTMLを戻す
     */
    public function bookingCalendar($months=1)
    {
        // 年月表示形式
        $this->month = Translation::$yearMonthFormat[$this->lang];

        // 曜日表示データ
        $this->week = Translation::$week[$this->lang];
        //$this->captionLink = true;
        //$this->prev = '⬅';
        //$this->next = '➡';
        $this->prev_prev = $this->next_next = '';

        // カレンダー表示ページのURL
        $this->linkUrl = get_permalink();

        // TDタグ日付内の表示処理コール先をセットする
        $this->callTdCell = array($this, 'tdCell');

        ob_start();
?>
        <div class="schedule-calendar month-<?php echo $months ?>">
            <?php echo $this->monthCalendar($this->oCalendar) ?>
        </div>

<?php
        return ob_get_clean();
    }

    /**
     * カレンダー１日枠の表示
     */
    public function tdCell($datetime)
    {
        $rental = $this->rentals[$datetime];

        echo sprintf('<td class="%s">', implode(' ', $rental['classes']));

        // day number
        $day = date('j', $datetime);

        $dayOut = '';
        echo sprintf('<div class="day-number" data-datetime="%d"><span class="day-number-str">%d</span>%s</div>',
            $datetime, $day, $dayOut);

        $status = $rental['status'];
        echo sprintf('<div class="day-status %s">%s</div>', $status, Config::$marking[$status]);

        echo sprintf('<div class="day-note">%s</div>', $rental['memo']);

        echo "</td>\n";
    }

}
