/**
 * 入力支援モジュール
 *
 * @Filename    mts-assistance.js
 * @Author      S.Hayashi
 * @Code        2015-12-08 Ver.1.0.0
 *
 * Updated to 1.1.0 on 2017-03-09
 * Updated to 1.1.1 on 2017-07-19
 * Updated to 1.2.0 on 2018-09-03
 * Updated to 1.3.0 on 2019-05-01
 */
var MtsAssistance = function($)
{

    // ローディングアイコン表示 ON OFF
    var loadingIcon = function(iconId, loading)
    {
        var attr = loading ? 'inline-block' : 'none';

        $('#' + iconId).css('display', attr);
    };

    /**
     * 郵便番号検索
     */
    this.findByPostcode = function(apiKey, postcodeId, prefId, cityId, townId)
    {
        var setsegs = [prefId, cityId, townId];

        var iconId = postcodeId + "-loading";
        loadingIcon(iconId, true);

        $.ajax({
            type : 'get',
            url : 'https://maps.googleapis.com/maps/api/geocode/json',
            crossDomain : true,
            dataType : 'json',
            data : {
                address : this.zenToHan($("#" + postcodeId).val()),
                language : 'ja',
                sensor : false,
                key : apiKey,
            },
            success : function(ret){
                loadingIcon(iconId, false);
                if (ret.status == "OK" && isDomestic(ret.results[0].formatted_address)) {
                    setAddress(setsegs, ret.results[0].address_components);
                } else {
                    clearInput(setsegs, 0);
                }
                return false;
            }
        });
    };

    // 国内の住所か確認する
    var isDomestic = function(fmtaddr)
    {
        return fmtaddr.match(/日本/);
    };

    /**
     * 住所を指定セグメントにセットする
     *
     * @setseg  フォームのセグメントID配列
     * @addr    Google Geocoding APIの検索結果(都道府県は配列降順、最後は郵便番号)
     */
    var setAddress = function(setseg, addr)
    {
        var idx = 0;

        // 国名を取得
        locality = addr.pop();

        // 先頭が「日本」でない場合は検索結果なしとする
        if (isDomestic(locality.long_name)) {
            for (var i = addr.length; 0 < i && idx < setseg.length; i--) {
                locality = addr.pop();
                // 郵便番号なら終了
                if (locality.long_name.match(/\d{3}-\d{4}/)) {
                    break;
                }
                // 住所をセットする
                $('#' + setseg[idx]).val(locality.long_name);
                idx++;
            }
        }

        // 未設定の入力項目をクリアする
        clearInput(setseg, idx);
    };

    // 未設定の入力項目をクリアする
    var clearInput = function(setseg, idx)
    {
        for ( ; idx < setseg.length; idx++) {
            $('#' + setseg[idx]).val('');
        }
    };

    /**
     * 英数字全角半角変換
     */
    this.zenToHan = function(postcode)
    {
        var str = postcode.replace(/ー/g, '－');

        str = str.replace(/[０-９Ａ-Ｚａ-ｚ－]/g, function(s) {
            return String.fromCharCode(s.charCodeAt(0) - 0xfee0)
        });

        return str;
    };

};

var mts_assistance = new MtsAssistance(jQuery);
