/**
 * MTS Car Booking 営業カレンダー管理
 *
 * @Filename    calendar-admin.js
 * @Author      S.Hayashi
 * @Code        2018-08-02 Ver.1.0.0
 */
const CalendarAdmin = function($)
{
    let weeks = ['日', '月', '火', '水', '木', '金', '土'];

    // 年月日曜日
    let dateWeek = function (oDay)
    {
        return oDay.getFullYear() + '年' + (oDay.getMonth() + 1) + '月' + oDay.getDate() + '日 (' + weeks[oDay.getDay()] + ')';
    };

    // 指定日付の営業データをダイアログにセットする
    let setDialogData = function ($dayMemo) {
        let day = new Date($dayMemo.data('datetime') * 1000);

        // 編集日時の表示設定
        $("#shop-day-date").text(dateWeek(day));

        // 営業日チェックボックス設定
        $("input[name=shop_open_close]").val([$dayMemo.data('open')]);

        // class属性設定
        $("#shop-day-class").val($dayMemo.data('class'));

        // 注記設定
        let memo = $dayMemo.data('memo');
        $("input[id^='shop-day-memo']").each(function () {
            let lang = $(this).data('lang');
            if (lang in memo) {
                $(this).val(memo[lang]);
            } else {
                $(this).val('');
            }
        });
    };

    // 編集した営業データをセットする
    let editShopDay = function ($dayMemo)
    {
        // 営業日
        let fOpen = parseInt($("input[name=shop_open_close]:checked").val());

        $dayMemo.data('open', fOpen);
        // class属性
        $dayMemo.data('class', $("#shop-day-class").val());

        // 注記
        let memo = {};
        $("input[id^='shop-day-memo']").each(function (idx) {
            let lang = $(this).data('lang');
            memo[lang] = $(this).val();

            // カレンダー内に表示
            if (idx === 0) {
                $dayMemo.text(memo[lang]);
            }
        });
        $dayMemo.data('memo', memo);

        // 営業日のカレンダーclass書き換え
        if (fOpen) {
            $dayMemo.parent().removeClass('shop-close');
        } else {
            $dayMemo.parent().addClass('shop-close');
        }
    };

    // 営業データ編集ダイアログ
    let shopDayDialog = function ($dayMemo)
    {
        // ダイアログのパラメータ
        let param = {
            'title': 'カレンダーの設定',
            'width': 400,
            'dialogClass': 'wp-dialog',
            'modal': true,
            'autoOpen': false,
            'closeOnEscape': true,
            'buttons': [
                {
                    'text': '変更する',
                    'class': 'button-secondary',
                    'click': function () {
                        editShopDay($dayMemo);
                        $(this).dialog('close');
                    }
                },
                {
                    'text': 'キャンセル',
                    'class': 'button-secondary',
                    'click': function () {
                        // ダイアログボックスをクローズする
                        $(this).dialog('close');
                    }
                }
            ]
        };

        // ダイアログデータの設定
        setDialogData($dayMemo);

        // ダイアログを表示する
        $("#shop-day-dialog").dialog(param).dialog('open');
    };

    // カレンダーの指定曜日を全休日(営業日)に変更する
    let alterWeekly = function (shop, weekly)
    {
        if (shop === 'close') {
            $("td." + weekly + ":not(.no-day)").each(function () {
                $(this).addClass('shop-close');
                $(this).find(".day-memo").data('open', 0);
            });
        } else {
            $("td." + weekly + ":not(.no-day)").each(function () {
                $(this).removeClass('shop-close');
                $(this).find(".day-memo").data('open', 1);
            });
        }
    };

    // 注記オブジェクトを戻す
    let newMemo = function (str)
    {
        let memo = {};

        // 多言語のテンプレートデータを生成する
        $("input[id^='shop-day-memo']").each(function (idx) {
            let lang = $(this).data('lang');
            memo[lang] = idx === 0 ? str : '';
        });

        return memo;
    };

    // 祝祭日を取り込む
    let getHolidays = function ()
    {
        let idx0 = '';

        // 祝祭日データを取り込む
        let holidays = $("#national-holidays").val();

        // 祝祭日データが空なら終了する
        if (holidays === '') {
            alert($("#check-holidays").text());
            return;
        }

        // オブジェクトに変換する
        holidays = JSON.parse(holidays);

        // 多言語のテンプレートデータを生成する
        $("input[id^='shop-day-memo']").each(function (idx) {
            let lang = $(this).data('lang');
            if (idx === 0) {
                idx0 = lang;
            }
        });

        // 祝祭日カレンダーにセットする
        $.each(holidays, function(index, value) {
            let $dayMemo = $(".day-memo[data-datetime='" + index + "']");
            if ($dayMemo) {
                $dayMemo.parents('td').addClass('holiday');
                $dayMemo.data('class', 'holiday');
                $dayMemo.data('memo', newMemo(value));
                $dayMemo.text(value);
            }
        });
    };

    /**
     * カレンダーデータを送信前にセットする
     */
    this.setCalendarData = function ()
    {
        let calendar = {};

        $(".admin-eigyo-calendar .day-memo").each(function (idx) {
            calendar[$(this).data('datetime')] = {
                'open' : $(this).data('open'),
                'class' : $(this).data('class'),
                'memo' : $(this).data('memo')
            };
        });

        $("#shop_calendar_data").val(JSON.stringify(calendar));

        return true;
    };


    $(document).ready(function ()
    {
        let weekly;

        // カレンダー日の編集
        $(".admin-eigyo-calendar td").click(function() {
            if ($(this).hasClass('no-day')) {
                return;
            }

            shopDayDialog($(this).find('.day-memo'));
        });

        // 特定曜日を一括で休業日に変更する
        $("#alter-weekly-close").click(function() {
            weekly = $("#alter-day-week").val();
            if (weekly != -1) {
                alterWeekly('close', weekly);
            }
        });

        // 特定曜日を一括で営業に変更する
        $("#alter-weekly-open").click(function() {
            weekly = $("#alter-day-week").val();
            if (weekly != -1) {
                alterWeekly('open', weekly);
            }
        });

        // 祝祭日データを取り込む
        $("#get-holidays").click(function() {
            getHolidays();
        });

    });

};

const mtsrcb_calendar_admin = new CalendarAdmin(jQuery);
