/**
 * MTS Car Booking フロントエンド予約処理
 *
 * @Filename    booking-car.js
 * @Author      S.Hayashi
 * @Code        2018-10-05 Ver.1.0.0
 */
const BookingCar = function($)
{
    // 日付入力対象項目
    let entryId = 'rent-start';

    // カレンダー表示情報
    let vehicleId = 0;
    let monthTime = null;
    let linkLast = null;
    let linkFuture = null;

    // AJAXパラメータ
    let ajaxp = {
        'action': 'mtsrcb_ajax',
        'module': 'booking-car',
        'method': '',
        'nonce': ''
    };

    /*+
     * jQueryバージョン
    */
    this.version = function () {
        alert($().jquery);
    };

    // ローディングアイコン表示切替
    let loadingIcon = function (sw) {
        $("#month-calendar-loading").css('display', sw ? 'block' : 'none');
    };

    /**
     * カレンダー切替
     */
    this.changeMonth = function (action)
    {
        let newMonth = new Date(monthTime * 1000);

        // 表示対象月
        newMonth.setUTCMonth(newMonth.getUTCMonth() + action);

        // カレンダーの切替表示
        changeCalendar(newMonth);
    };

    let changeCalendar = function (newMonth)
    {
        // AJAXパラメータ設定
        ajaxp.method = 'changeCalendar';
        ajaxp.nonce = $("#rental-nonce").val();
        ajaxp.proc = 'calendar';
        ajaxp.vehicle_id = vehicleId;
        ajaxp.month = parseInt(newMonth.getTime() / 1000);
        ajaxp.lang = localform.lang;

        // ローディングアイコン表示
        loadingIcon(1);

        // Ajax送信
        $.ajax({
            type: 'post',
            url: localform.ajaxurl,
            data: ajaxp,
            dataType: 'json'
        })
            .done(function (result) {
                if (!result.result) {
                    alert(result.result === false ? result.html : 'Error');
                } else {
                    // カレンダークリックハンドラー削除
                    $("#month-calendar td").off('click');
                    // カレンダーDOM削除
                    $("#month-calendar .schedule-calendar").remove();
                    // カレンダーDOM追加
                    $("#month-calendar").html(result.html);
                    // カレンダークリックハンドラー追加
                    setClickCalendar();

                    // カレンダーリンク状態の更新
                    updateLink();
                }

                // ローディングアイコン消去
                loadingIcon(0);
            })
            .fail(function (fail) {
                console.log(fail);
                alert('異常終了しました。');

                // ローディングアイコン消去
                loadingIcon(0);
            });
    };

    // カレンダー切り替えボタンのリンク状態を更新する
    let updateLink = function ()
    {
        // 表示年月日の更新
        monthTime = parseInt($("#month-calendar").find(".caption-title").data('month_time'));
        $("#calendar-link-title").attr('data-month_time', monthTime)
            .text(dateStr(localform.yearMonthFormat, monthTime));

        // 前月ボタン機能の無効化
        $("#change-prev").prop("disabled", monthTime <= linkLast);

        // 翌月ボタン機能の無効化
        $("#change-next").prop("disabled", linkFuture <= monthTime);

        // カレンダー表示月
        //$("#calendar-month").val(monthTime);
    };

    // 日付入力項目にカレンダー上で選択された日付をセットする
    let dateStr = function (dateFormat, datetime)
    {
        let oDay = new Date(datetime * 1000);
        let form = dateFormat.split("");
        let reForm = '';

        let mon = oDay.getUTCMonth() + 1;
        let date = oDay.getUTCDate();
        let day = oDay.getUTCDay();

        for (let i = 0; i < form.length; i++) {
            let mark = form[i];
            switch (mark) {
                case 'Y':
                    mark = oDay.getUTCFullYear();
                    break;
                case 'm':
                    mark = ('0' + mon).slice(-2);
                    break;
                case 'n':
                    mark = mon;
                    break;
                case 'd':
                    mark = ('0' + date).slice(-2);
                    break;
                case 'j':
                    mark = date;
                    break;
                case 'M':
                    mark = 0 < localform.monthM.length ? localform.monthM[mon - 1] : mon;
                    break;
                case 'F':
                    mark = 0 < localform.monthF.length ? localform.monthF[mon - 1] : mon;
                    break;
                case 'S':
                    let tail = date.toString().slice(-1);
                    mark = 'th';
                    if (date < 11 || 19 < date) {
                        if (tail === '1') {
                            mark = 'st';
                        } else if (tail === '2') {
                            mark = 'nd';
                        } else if (tail === '3') {
                            mark = 'rd';
                        }
                    }
                    break;
                case 'D':
                    mark = 0 < localform.week.length ? localform.week[day] : day;
                    break;
            }

            reForm += mark;
        }

        return(reForm);
    };

    // 日付入力項目に日付をセットするカレンダーのクリックイベントハンドラーを追加
    let setClickCalendar = function ()
    {
        $("#month-calendar td").on('click', function () {
            if ($(this).find('.day-status').hasClass('available')) {
                // 日時データをセットする
                let datetime = $(this).find('.day-number').data('datetime');
                // 送信入力項目にセットする
                $("#" + entryId).val(datetime);
                $("#date-" + entryId).val(dateStr(localform.dateFormat, datetime));
                // フォーカス移動
                if (entryId === 'rent-start') {
                    $("#date-rent-start").removeClass('focused');
                    entryId = 'rent-end';
                    $("#date-rent-end").addClass('focused');
                }
            }
        });
    };

    $(document).ready(function ()
    {
        // カレンダー表示情報を取得する
        monthTime = parseInt($("#calendar-link-title").data('month_time'));
        //monthTime = parseInt(data.month_time);
        vehicleId = parseInt($("#vehicle-id").val()); //parseInt(data.vehicle_id);
        linkLast = parseInt($("#calendar-link-prev").data('link_last'));
        linkFuture = parseInt($("#calendar-link-next").data('link_future'));

        // 日付入力項目のFocusIn
        $("input.date-entry").focusin(function() {
            $("input.date-entry").removeClass('focused');
            $(this).addClass('focused');
            entryId = $(this).attr('id').substring(5);
        });

        // 日付入力ハンドラーをセットする
        setClickCalendar();
    });

};

const mtsrcb_booking_car = new BookingCar(jQuery);
