<?php
/**
 * MTS Car Booking カスタムポストデータ定義モジュール
 *
 * @Filename    CustomPost.php
 * @Author      S.Hayashi
 * @CODE        2018-06-27 Ver.1.0.0
 */
namespace MTSCarBookingTrial;

class CustomPost
{
    const VEHICLE = 'mtsrcb_vehicle';
    const VHEICLE_TYPE = 'mtsrcb_vehicle_type';
    const CHARGE = 'mtsrcb_charge';
    const OPTION = 'mtsrcb_option';
    const MAIL_TEMPLATE = 'mtsrcb_mail';

    const CAPABILITY = 'install_plugins';

    /**
     * Constructor
     */
    public function __construct()
    {
        add_action('init', array($this, 'registerCustomPostType'));
        add_action('after_switch_theme', array($this, 'flushRewrite'));
    }

    /**
     * カスタム投稿タイプの登録
     */
    public function registerCustomPostType()
    {
        // カスタム投稿タイプを登録する
        $this->_initVehicle();
        $this->_initCharge();
        $this->_initOption();
        $this->_initMailTemplate();
    }

    // 車両管理のカスタムポストタイプの登録(initアクションで実行の事)
    private function _initVehicle()
    {
        $labels = array(
            'name' => '車両一覧',
            'singular_name' => '車両',
            'all_items' => '登録車両一覧',
            'add_new' => '新規追加',
            'add_new_item' => '車両 新規追加',
            'edit_item' => '車両編集',
            'new_item' => '車両新規',
            'view_item' => '車両表示',
            'search_items' => '車両を検索',
            'menu_name' => '車両管理',
        );

        $args = array(
            'labels' => $labels,
            'public' => false,
            //'exclude_from_search' => true,
            //'publicly_queryable' => false,
            //'show_in_admin_bar' => false,
            //'show_in_nav_menus' => false,
            'show_ui' => true,
            'show_in_menu' => true,
            'menu_position' => CarBooking::MENU_POSITION + 1,
            'menu_icon' => 'dashicons-list-view',
            'capabilities' => array(
                'edit_post' => self::CAPABILITY,
                'read_post' => self::CAPABILITY,
                'delete_post' => self::CAPABILITY,
                'edit_posts' => self::CAPABILITY,
                'edit_others_posts' => self::CAPABILITY,
                'publish_posts' => self::CAPABILITY,
                'read_private_posts' => self::CAPABILITY,
                'read' => self::CAPABILITY,
                'delete_posts' => self::CAPABILITY,
                'delete_private_posts' => self::CAPABILITY,
                'delete_published_posts' => self::CAPABILITY,
                'delete_others_posts' => self::CAPABILITY,
                'edit_private_posts' => self::CAPABILITY,
                'edit_published_posts' => self::CAPABILITY,
                'create_posts' => self::CAPABILITY,
            ),
            'supports' => array('title', 'page-attributes'),
            //'hierarchical' => false,
            'taxonomies' => array(self::VHEICLE_TYPE),
            //'register_meta_box_cb' => array($this, 'registerMetaBox'),
            //'rewrite' => false,
        );

        // カスタム投稿タイプ mtsrcb_vehicle を登録する
        register_post_type(self::VEHICLE, $args);

        // カテゴリー(車種タイプ) 取り扱いを設定する
        $this->_registerVehicleType();
    }

    // カテゴリー(車種タイプ) 取り扱いを設定する
    private function _registerVehicleType()
    {
        $labels = array(
            'name' => '車種',
            'singular_name' => '車種管理',
            'search_items' => '車種を検索',
            'all_items' => '車種一覧',
            'edit_item' => '車種編集',
            'update_item' => '車種更新',
            'add_new_item' => '車種の新規追加',
            'new_item_name' => '新規車種',
            'separate_items_with_commas' => '複数車種の指定はコンマで区切って下さい。',
            'add_or_remove_items' => '車種の追加・削除',
            'choose_from_most_used' => '利用頻度の高い車種',
            'not_found' => '車種は見つかりませんでした。',
            'menu_name' => '車種管理',
        );

        $args = array(
            'public' => false,
            'rewrite' => false,
            'labels' => $labels,
            'show_ui' => true,
            'show_admin_column' => true,
            //'show_in_menu' => true,
            'hierarchical' => true,
            //'update_count_callback' => '_update_post_term_count',
            //'rewrite' => array('slug' => 'article_group'),
        );

        register_taxonomy(self::VHEICLE_TYPE, self::VEHICLE, $args);
    }

    // オプションのカスタムポストタイプの登録(initアクションで実行の事)
    private function _initOption()
    {
        $labels = array(
            'name' => 'オプション一覧',
            'singular_name' => 'オプション',
            'all_items' => 'オプション一覧',
            'add_new' => 'オプション追加',
            'add_new_item' => 'オプション 新規追加',
            'edit_item' => 'オプション編集',
            'new_item' => 'オプション新規',
            'view_item' => 'オプション表示',
            'search_items' => 'オプションを検索',
            'menu_name' => 'オプション管理',
        );

        $args = array(
            'labels' => $labels,
            'public' => false,
            'show_ui' => true,
            'menu_position' => CarBooking::MENU_POSITION + 2,
            'menu_icon' => 'dashicons-list-view',
            'capabilities' => array(
                'edit_post' => self::CAPABILITY,
                'read_post' => self::CAPABILITY,
                'delete_post' => self::CAPABILITY,
                'edit_posts' => self::CAPABILITY,
                'edit_others_posts' => self::CAPABILITY,
                'publish_posts' => self::CAPABILITY,
                'read_private_posts' => self::CAPABILITY,
                'read' => self::CAPABILITY,
                'delete_posts' => self::CAPABILITY,
                'delete_private_posts' => self::CAPABILITY,
                'delete_published_posts' => self::CAPABILITY,
                'delete_others_posts' => self::CAPABILITY,
                'edit_private_posts' => self::CAPABILITY,
                'edit_published_posts' => self::CAPABILITY,
                'create_posts' => self::CAPABILITY,
            ),

            'supports' => array('title', 'page-attributes'),
            'taxonomies' => array(self::VHEICLE_TYPE),
        );

        // カスタム投稿タイプ mtsrcb_charge を登録する
        register_post_type(self::OPTION, $args);
    }

    // 料金表のカスタムポストタイプの登録(initアクションで実行の事)
    private function _initCharge()
    {
        $labels = array(
            'name' => '料金表一覧',
            'singular_name' => '料金表',
            'all_items' => '料金表一覧',
            'add_new' => '料金表追加',
            'add_new_item' => '料金表 新規追加',
            'edit_item' => '料金表編集',
            'new_item' => '料金表新規',
            'view_item' => '料金表表示',
            'search_items' => '料金表を検索',
            'menu_name' => '料金表管理',
        );

        $args = array(
            'labels' => $labels,
            'public' => false,
            'show_ui' => true,
            'menu_position' => CarBooking::MENU_POSITION + 3,
            'menu_icon' => 'dashicons-list-view',
            'capabilities' => array(
                'edit_post' => self::CAPABILITY,
                'read_post' => self::CAPABILITY,
                'delete_post' => self::CAPABILITY,
                'edit_posts' => self::CAPABILITY,
                'edit_others_posts' => self::CAPABILITY,
                'publish_posts' => self::CAPABILITY,
                'read_private_posts' => self::CAPABILITY,
                'read' => self::CAPABILITY,
                'delete_posts' => self::CAPABILITY,
                'delete_private_posts' => self::CAPABILITY,
                'delete_published_posts' => self::CAPABILITY,
                'delete_others_posts' => self::CAPABILITY,
                'edit_private_posts' => self::CAPABILITY,
                'edit_published_posts' => self::CAPABILITY,
                'create_posts' => self::CAPABILITY,
            ),

            'supports' => array('title', 'page-attributes'),
        );

        // カスタム投稿タイプ mtsrcb_charge を登録する
        register_post_type(self::CHARGE, $args);
    }

    // メールテンプレートのカスタムポストタイプの登録(initアクションで実行の事)
    private function _initMailTemplate()
    {
        $labels = array(
            'name' => 'メールテンプレ一覧',
            'singular_name' => 'メールテンプレート',
            'all_items' => 'テンプレート一覧',
            'add_new' => 'テンプレート追加',
            'add_new_item' => 'メールテンプレート 新規追加',
            'edit_item' => 'メールテンプレート編集',
            'new_item' => 'メールテンプレート新規',
            'view_item' => 'メールテンプレート表示',
            'search_items' => 'メールテンプレートを検索',
            'menu_name' => 'メール管理',
        );

        $args = array(
            'labels' => $labels,
            'public' => false,
            'show_ui' => true,
            'menu_position' => CarBooking::MENU_POSITION + 4,
            'menu_icon' => 'dashicons-list-view',
            'capabilities' => array(
                'edit_post' => self::CAPABILITY,
                'read_post' => self::CAPABILITY,
                'delete_post' => self::CAPABILITY,
                'edit_posts' => self::CAPABILITY,
                'edit_others_posts' => self::CAPABILITY,
                'publish_posts' => self::CAPABILITY,
                'read_private_posts' => self::CAPABILITY,
                'read' => self::CAPABILITY,
                'delete_posts' => self::CAPABILITY,
                'delete_private_posts' => self::CAPABILITY,
                'delete_published_posts' => self::CAPABILITY,
                'delete_others_posts' => self::CAPABILITY,
                'edit_private_posts' => self::CAPABILITY,
                'edit_published_posts' => self::CAPABILITY,
                'create_posts' => self::CAPABILITY,
            ),

            'supports' => array('title', 'page-attributes'),
        );

        // カスタム投稿タイプ mtsrcb_charge を登録する
        register_post_type(self::MAIL_TEMPLATE, $args);
    }

    /**
     * アクティベーション、テーマ切替え時のフラッシュ処理
     */
    public function flushRewrite()
    {
        $this->registerCustomPostType();
        flush_rewrite_rules();
    }

}
