<?php
/**
 *  MTS Autoloader MTSプラグインクラスローダーモジュール
 *
 * @Filename    bootstrap.php
 * @Author      S.Hayashi
 * @Date        2014-01-26
 */

if (!class_exists('MtsAutoloader')) {
    /**
     * Autoloader CLASS for MTS WordPress Plugins
     *
     */
    class MtsAutoloader
    {
        private $plugins = array();

        public static function getInstance()
        {
            static $iLoader;

            if (!$iLoader) {
                $iLoader = new MtsAutoloader;
            }

            return $iLoader;
        }

        private function __construct()
        {
            spl_autoload_register(array($this, 'autoloader'));
        }

        public function setPluginDir($plugin, $dir)
        {
            $this->plugins[$plugin] = $dir;
        }

        public function autoloader($classname)
        {
            foreach ($this->plugins as $plugin => $dir) {
                if (stripos($classname, $plugin) === 0) {
                    $pathname = str_replace('\\', DIRECTORY_SEPARATOR, $classname);
                    $fpath = $dir . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR . "$pathname.php";
                    if (file_exists($fpath)) {
                        require $fpath;
                        return;
                    }

                    die("Not Exists {$fpath}.");
                }
            }
        }
    }
}
