<?php
/**
 * MTS Car Booking オプション管理のビュー
 *
 * @Filename    OptionAdminView.php
 * @Author      S.Hayashi
 * @Code        2018-07-11 Ver.1.0.0
 */
namespace MTSCarBookingTrial\views;

use MTSCarBookingTrial\Config;
use MTSCarBookingTrial\CustomPost;
use MTSCarBookingTrial\OptionAdmin;
use MTSCarBookingTrial\ChargeAdmin;
use MTSCarBookingTrial\models\Option;
use MTSCarBookingTrial\models\Charge;

class OptionAdminView
{
    const PAGE_NAME = OptionAdmin::PAGE_NAME;

    const JS = 'js/vehicle-admin.js';
    const CSS = 'css/mtsrcb-admin.css';

    private static $typeTitle = array(
        0 => '選択',
        1 => '必須',
    );

    private static $cntlTitle = array(
        0 => 'しない',
        1 => 'する',
    );

    private $oHelper = null;

    /**
     * Constructor
     */
    public function __construct(Option $oOption)
    {
        $this->oHelper = FormHelper::getInstance();

        // JavaScript、CSSソースの読み込み指定
        add_action('admin_enqueue_scripts', array($this, 'enqueueScript'));

        // 管理画面追加編集ブロック登録
        $idname = self::PAGE_NAME . '-';
        add_meta_box("{$idname}name", 'オプション名称', array($this, 'nameBox'), CustomPost::OPTION, 'normal', 'default', array('oOption' => $oOption));
        add_meta_box("{$idname}type", '種別', array($this, 'typeBox'), CustomPost::OPTION, 'normal', 'default', array('oOption' => $oOption));
        add_meta_box("{$idname}charge", '料金', array($this, 'chargeBox'), CustomPost::OPTION, 'normal', 'default', array('oOption' => $oOption));
        add_meta_box("{$idname}image", 'オプション画像', array($this, 'imageBox'), CustomPost::OPTION, 'normal', 'default', array('oOption' => $oOption));
    }

    /**
     * JavaScript,Style headタグ内のロード登録
     */
    public function enqueueScript()
    {
        $dir = dirname(__FILE__);

        wp_enqueue_script(self::PAGE_NAME, plugins_url(self::JS, $dir), array('jquery'));//, 'jquery-ui-dialog'));
        wp_enqueue_media();
        wp_enqueue_style(self::PAGE_NAME, plugins_url(self::CSS, $dir));
    }

    /**
     * オプション名称
     */
    public function nameBox($oPost, $meta)
    {
        $oOption = $meta['args']['oOption'];

        foreach (Config::$languages as $lang => $title) {
            echo '<div class="line-box">';
            echo sprintf('<label for="name-%s" class="lang-title">%s</label>', $lang, $title);
            echo $this->oHelper->textBox("name-{$lang}", 'mts-middle', "option[name][{$lang}]", (property_exists($oOption->name, $lang) ? $oOption->name->$lang : ''));
            echo "</div>\n";
        }

        echo sprintf('<input type="hidden" name="option_nonce" value="%s">', wp_create_nonce(self::PAGE_NAME));
    }

    /**
     * 選択種別
     */
    public function typeBox($oPost, $meta)
    {
        $oOption = $meta['args']['oOption'];

?>
        <table class="mts-form-table">
            <tr>
                <th>選択種別</th>
                <td class="select-row">
                    <?php echo $this->oHelper->radioButton('option-type', '', 'option[type]', self::$typeTitle, $oOption->type) ?>
                </td>
            </tr>
            <tr>
                <th>貸出管理</label></th>
                <td class="select-row">
                    <?php echo $this->oHelper->radioButton('option-inventory', '', 'option[inventory]', self::$cntlTitle, $oOption->inventory) ?>
                </td>
            </tr>
            <tr>
                <th><label for="option-quantity">在庫総数</label></th>
                <td>
                    <?php echo $this->oHelper->textBox('option-quantity', 'mts-small-number', 'option[quantity]', $oOption->quantity) ?>
                    <div class="mts-description">必須オプションの場合、貸出数量の管理は実行されません。</div>
                </td>
            </tr>
        </table>

<?php
    }

    /**
     * 料金計算
     */
    public function chargeBox($oPost, $meta)
    {
        $oOption = $meta['args']['oOption'];

        $list = ChargeAdmin::listCharge(Charge::OPTION);
        $list = array(0 => '') + $list;
?>
        <table class="mts-form-table">
            <tr>
                <th>料金計算</th>
                <td class="select-row">
                    <?php echo $this->oHelper->radioButton('option-calculation', '', 'option[calculation]', self::$cntlTitle, $oOption->calculation) ?>
                </td>
            </tr>
            <tr>
                <th><label for="option-price">料金表</label></th>
                <td>
                    <?php echo $this->oHelper->selectBox('option-charge-id', '', 'option[charge_id]', $list, $oOption->charge_id) ?>
                </td>
            </tr>
        </table>

<?php
    }

    /**
     * オプション画像の設定
     */
    public function imageBox($oPost, $meta)
    {
        $oOption = $meta['args']['oOption'];

        echo '<table id="vehicle-image" class="image-box">' . "\n";

        for ($i = 0; $i < Option::NUMBER_OF_IMAGES; $i++) :
            $url = isset($oOption->image[$i]) ? $oOption->image[$i] : '';
?>
            <tr class="image-tr">
                <td class="car-thumbnail">
                    <img class="car-image" src="<?php echo $url ?>">
                </td>
                <td>
                    <input type="text" class="image-url" name="option[image][]" value="<?php echo $url ?>">
                    <input type="button" class="button" value="メディアライブラリから選択" onclick="mtsrcb_vehicle_admin.select(<?php echo $i ?>)">
                    <input type="button" class="button" value="クリア" onclick="mtsrcb_vehicle_admin.clear(<?php echo $i ?>)">
                </td>
            </tr>

<?php
        endfor;
        echo "</table>\n";

    }


}
