<?php
/**
 * MTS Car Booking メールテンプレート管理のビュー
 *
 * @Filename    MailTemplateAdminView.php
 * @Author      S.Hayashi
 * @Code        2018-08-09 Ver.1.0.0
 */
namespace MTSCarBookingTrial\views;

use MTSCarBookingTrial\Config;
use MTSCarBookingTrial\CustomPost;
use MTSCarBookingTrial\MailTemplateAdmin;
use MTSCarBookingTrial\models\MailTemplate;


class MailTemplateAdminView
{
    const PAGE_NAME = MailTemplateAdmin::PAGE_NAME;

    //const JS = 'js/charge-admin.js';
    const CSS = '/css/mtsrcb-admin.css';

    private $oHelper = null;

    private $oMailTemplateAdmin = null;

    private $dispMsg = false;

    /**
     * Constructor
     */
    public function __construct(MailTemplateAdmin $oMailTemplateAdmin)
    {
        //$this->oHelper = FormHelper::getInstance();
        $this->oMailTemplateAdmin = $oMailTemplateAdmin;

        // JavaScript、CSSソースの読み込み指定
        add_action('admin_enqueue_scripts', array($this, 'enqueueScript'));

        // 管理画面追加編集ブロック登録
        foreach (Config::$languages as $lang => $title) {
            add_meta_box(self::PAGE_NAME . "-mail-{$lang}", "メール文 {$title}", array($this, 'templateBox'), CustomPost::MAIL_TEMPLATE, 'normal', 'default',
                array('oMail' => $this->oMailTemplateAdmin->oTemplate->templates->$lang, 'lang' => $lang));
        }

        // エラー表示登録
        //add_action('admin_notices', array($this, 'errorBox'));
    }

    /**
     * JavaScript,Style headタグ内のロード登録
     */
    public function enqueueScript()
    {
        $dir = dirname(__FILE__);

        //wp_enqueue_script(self::PAGE_NAME, plugins_url(self::JS, $dir), array('jquery'));
        wp_enqueue_style(self::PAGE_NAME, plugins_url(self::CSS, $dir));
    }

    /**
     * 言語別メールテンプレートボックス
     */
    public function templateBox($oPost, $meta)
    {
        if (!$this->dispMsg) {
            $this->_outMessage();
        }

        $oMail = $meta['args']['oMail'];
        $lang = $meta['args']['lang'];

        $settings = array(
            'media_buttons' => false,
            'textarea_name' => "mail[{$lang}][message]",
            'tinymce' => false,
        );
?>
        <div class="mail-box">
            <div class="mail-template-item">
                <label for="mail-to-<?php echo $lang ?>">宛先</label>
                <input id="mail-to-<?php echo $lang ?>" type="text" class="mts-fat" name="mail[<?php echo $lang ?>][to]" value="<?php echo $oMail->to ?>">
            </div>
            <div class="mail-template-item">
                <label for="mail-cc-<?php echo $lang ?>">CC</label>
                <input id="mail-cc-<?php echo $lang ?>" type="text" class="mts-fat" name="mail[<?php echo $lang ?>][cc]" value="<?php echo $oMail->cc ?>">
            </div>
            <div class="mail-template-item">
                <label for="mail-bcc-<?php echo $lang ?>">BCC</label>
                <input id="mail-bcc-<?php echo $lang ?>" type="text" class="mts-fat" name="mail[<?php echo $lang ?>][bcc]" value="<?php echo $oMail->bcc ?>">
            </div>
            <div class="mail-template-item">
                <label for="mail-from-<?php echo $lang ?>">FROM</label>
                <input id="mail-from-<?php echo $lang ?>" type="text" class="mts-fat" name="mail[<?php echo $lang ?>][from]" value="<?php echo $oMail->from ?>">
            </div>
            <div class="mail-template-item">
                <label for="mail-replay_to-<?php echo $lang ?>">REPLAY TO</label>
                <input id="mail-teplay_to-<?php echo $lang ?>" type="text" class="mts-fat" name="mail[<?php echo $lang ?>][replay_to]" value="<?php echo $oMail->replay_to ?>">
            </div>

            <div class="mail-template-item">
                <label for="mail-subject-<?php echo $lang ?>">件名</label>
                <input id="mail-subject-<?php echo $lang ?>" type="text" class="mts-fat" name="mail[<?php echo $lang ?>][subject]" value="<?php echo $oMail->subject ?>">
            </div>
            <div class="mail-template-item">
                <label for="mail-message-<?php echo $lang ?>">本文</label>
                <?php wp_editor($oMail->message, "mail-message-{$lang}", $settings); ?>
            </div>
            <input type="hidden" name="<?php echo MailTemplateAdmin::NONCE_NAME ?>" value="<?php echo wp_create_nonce(self::PAGE_NAME) ?>">
        </div>

<?php
    }

    // エラーメッセージ表示
    public function _outMessage()
    {
        $this->dispMsg = true;

        if ($this->oMailTemplateAdmin->msgCode == '') {
            return;
        }

        echo sprintf('<div class="%s"><p><strong>%s: %s</strong></p></div>',
            ($this->oMailTemplateAdmin->errflg ? 'error' : 'update'), $this->oMailTemplateAdmin->msgCode, $this->oMailTemplateAdmin->msgSub);
    }

}
