<?php
/**
 * MTS Car Booking メール処理
 *
 * @Filename    Mail.php
 * @Author      S.Hayashi
 * @Code        2019-01-01 Ver.1.0.0
 */
namespace MTSCarBookingTrial\models;

use MTSCarBookingTrial\Config;
use MTSCarBookingTrial\CustomPost;

class Mail
{
    private $data = array(
        'to' => '',
        'cc' => '',
        'bcc' => '',
        'from' => '',
        'replay_to' => '',
        'subject' => '',
        'message' => '',
        'attachment' => array(),
    );

    public $postId = 0;
    public $metaKey = '';

    public $lang = '';

    public $errCode = '';
    public $errSub = '';

    /**
     * Constructor
     */
    public function __construct($lang=Config::LANG)
    {
        $this->lang = $lang;

        $this->from = get_option('admin_email');
    }

    /**
     * テンプレートを取得する
     */
    public static function readTemplate($postId, $lang='')
    {
        $oMail = new Mail;

        $oMail->metaKey = CustomPost::MAIL_TEMPLATE . ($lang != '' ? sprintf('_%s', strtolower($lang)) : '');
        $oMail->lang = $lang;

        $metaVal = get_post_meta($postId, $oMail->metaKey, true);

        if ($metaVal) {
            $oMail->postId = intval($postId);
            $oMail->setTemplate($metaVal);
        }

        else {
            $oMail->from = sprintf('%s <%s>', get_option('blogname', ''), get_option('admin_email'));
        }

        return $oMail;
    }

    /**
     * postmetaデータをプロパティにセットする
     */
    public function setTemplate($data)
    {
        $this->to = $data['to'];
        $this->cc = $data['cc'];
        $this->bcc = $data['bcc'];
        $this->from = $data['from'];
        $this->replay_to = $data['replay_to'];
        $this->subject = $data['subject'];
        $this->message = $data['message'];

        if (isset($data['attachment'])) {
            $this->attachemnet = $data['attachment'];
        }

        return $this;
    }

    /**
     * テンプレートの変数を置換する
     */
    public function replacementVars(Alternate $oAlternate)
    {
        // 送信先
        $this->to = apply_filters('mtsrcb_mail_to', $oAlternate->replaceVar($this->to), $this->to, $oAlternate);

        // CC
        $this->cc = apply_filters('mtsrcb_mail_cc', $oAlternate->replaceVar($this->cc), $this->cc, $oAlternate);

        // BCC
        $this->bcc = apply_filters('mtsrcb_mail_bcc', $oAlternate->replaceVar($this->bcc), $this->bcc, $oAlternate);

        // FROM
        $this->from = apply_filters('mtsrcb_mail_from', $oAlternate->replaceVar($this->from), $this->from, $oAlternate);

        // REPLAY TO
        $this->replay_to = apply_filters('mtsrcb_mail_replay', $oAlternate->replaceVar($this->replay_to), $this->replay_to, $oAlternate);

        // 件名
        $this->subject = apply_filters('mtsrcb_mail_subject', $oAlternate->replaceVar($this->subject), $oAlternate);

        // メール送信文
        $this->message = apply_filters('mtsrcb_mail_message', $oAlternate->replaceVar($this->message), $oAlternate);
    }

    /**
     * メール送信
     */
    public function sendMail(Alternate $oAlternate=null)
    {
        // 予約データ変数の置換え
        if ($oAlternate) {
            $this->replacementVars($oAlternate);
        }

        // ヘッダー
        $headers = array();

        if ($this->from != '') {
            $headers[] = sprintf('From: %s', $this->from);
        }

        if ($this->cc != '') {
            $aCc = explode(',', $this->cc);
            foreach ($aCc as $cc) {
                $headers[] = sprintf('Cc: %s', $cc);
            }
        }

        if ($this->bcc != '') {
            $aBcc = explode(',', $this->bcc);
            foreach ($aBcc as $bcc) {
                $headers[] = sprintf('Bcc: %s', $bcc);
            }
        }

        // ユーザーヘッダー追加
        $headers += apply_filters('mtsrcb_add_mail_header', array(), $headers);

        if (!wp_mail($this->to, $this->subject, $this->message, $headers)) {
            return $this->_setError('FAILED_SENDING_MAIL');
        };

        return true;
    }

    // エラーセット
    private function _setError($code, $sub='')
    {
        $this->errCode = $code;
        $this->errSub = $sub;
        return false;
    }

    /**
     * プロパティ設定
     */
    public function setProperty($key, $val)
    {
        $this->data[$key] = $val;
    }

    /**
     * プロパティ取得
     */
    public function getData()
    {
        return $this->data;
    }


    /**
     * プロパティから読み出す
     */
    public function __get($key)
    {
        if (array_key_exists($key, $this->data)) {
            if (is_array($this->data[$key])) {
                return (object) $this->data[$key];
            }
            return $this->data[$key];
        }

        if (isset($this->$key)) {
            return $this->$key;
        }

        $trace = debug_backtrace();
        trigger_error(sprintf(
            "Undefined property: '%s&' in %s on line %d, E_USER_NOTICE",
            $key, $trace[0]['file'], $trace[0]['line']
        ));

        return null;
    }

    /**
     * プロパティをセットする
     */
    public function __set($key, $value)
    {
        if (array_key_exists($key, $this->data)) {
            if (is_array($value)) {
                foreach ($value as $item => $val) {
                    $this->data[$key][$item] = $val;
                }
            } else {
                $this->data[$key] = $value;
            }
        } else {
            $this->$key = $value;
        }

        return $value;
    }

}
