/**
 * MTS Car Booking レンタル予定表管理
 *
 * @Filename    budget-admin.js
 * @Author      S.Hayashi
 * @Code        2018-09-26 Ver.1.0.0
 */
const BudgetAdmin = function($)
{
    // レンタル日時選択
    let dayFocus = 0;

    let weeks = ['日', '月', '火', '水', '木', '金', '土'];

    // 年月日曜日
    let dateWeek = function (oDay)
    {
        return oDay.getFullYear() + '年' + (oDay.getUTCMonth() + 1) + '月' + oDay.getUTCDate() + '日 (' + weeks[oDay.getUTCDay()] + ')';
    };

    // 日時
    let dateTime =　function (oDay)
    {
        return dateWeek(oDay) + ' ' + ('0' + oDay.getUTCHours()).slice(-2) + ':' + ('0' + oDay.getUTCMinutes()).slice(-2);
    };

    // ダイアログ入力データの予約フォーム項目設定
    let setFormItem = function (vehicleId, vehicleTitle, oDay)
    {
        // 入力時刻をセットする
        oDay.setUTCHours($("#rental-time-hour").val());
        oDay.setUTCMinutes($("#rental-time-minute").val());

        let dateStr = dateTime(oDay);
        let dayTime = oDay.getTime() / 1000;

        if (dayFocus === 0) {
            $("#budget-car").val(vehicleTitle);
            $("#budget-vehicle-id").val(vehicleId);
            $("#budget-start").val(dateStr);
            $("#budget-rent-start").val(dayTime);
            changeFocus(1);
        } else if (dayFocus === 1) {
            $("#budget-end").val(dateStr);
            $("#budget-rent-end").val(dayTime);
        }
    };

    // レンタル予約日時の入力ダイアログ
    let rentalDialog = function (vehicleId, vehicleTitle, oDay)
    {
        // ダイアログのパラメータ
        let param = {
            'title': 'レンタル日時の入力',
            'width': 400,
            'dialogClass': 'wp-dialog',
            'modal': true,
            'autoOpen': false,
            'closeOnEscape': true,
            'buttons': [
                {
                    'text': 'セット',
                    'class': 'button-secondary',
                    'click': function () {
                        setFormItem(vehicleId, vehicleTitle, oDay);
                        $(this).dialog('close');
                    }
                },
                {
                    'text': 'キャンセル',
                    'class': 'button-secondary',
                    'click': function () {
                        // ダイアログボックスをクローズする
                        $(this).dialog('close');
                    }
                }
            ]
        };

        let title = '貸渡予定';
        let hour = shop.open_hour;
        let min = shop.open_min;

        if (dayFocus !== 0) {
            title = '返却予定';
            hour = shop.close_hour;
            min = shop.close_min;
        }

        $("#rental-dialog-car").text(vehicleTitle);
        $("#rental-dialog-title").text(title + '：' + dateWeek(oDay));
        $("#rental-time-hour").val(hour);
        $("#rental-time-minute").val(min);

        // ダイアログを表示する
        $("#rental-time-dialog").dialog(param).dialog('open');
    };

    /**
     * レンタル予約フォームのクリア
     */
    this.formClear = function ()
    {
        $("#budget-car").val('');
        $("#budget-start").val('');
        $("#budget-end").val('');
        $("#budget-vehicle-id").val('');
        $("#budget-rent-start").val('');
        $("#budget-rent-end").val('');
        changeFocus(0);
    };

    /**
     * 予約日時入力データを引き継いでカレンダー表示を切り替える
     */
    this.turnCalendar = function (atag)
    {
        let param = {
            vehicle_id : $("#budget-vehicle-id").val(),
            rent_start : $("#budget-rent-start").val(),
            rent_end : $("#budget-rent-end").val()
        };

        let link = $(atag).attr('href');

        $.each(param, function (key, val) {
            if (0 < val.length) {
                link += '&' + key + '=' + val;
            }
        });

        $(atag).attr('href', link);

        return true;
    };

    // 日時入力対象項目のフォーカス変更
    let changeFocus = function (focus)
    {
        dayFocus = focus;

        if (dayFocus === 0) {
            $("#budget-start").addClass('input-focus');
            $("#budget-end").removeClass('input-focus');
        } else {
            $("#budget-start").removeClass('input-focus');
            $("#budget-end").addClass('input-focus');
        }
    };

    $(document).ready(function ()
    {
        $("td.budget-car").click(function () {
            // 閉店日と予約済みはスキップする
            if ($(this).hasClass('shop-close')) {
                return;
            }

            // 日付を取得する
            let oDay = new Date($(this).data('daytime') * 1000);

            // 車両IDと名称を取得する
            let $table = $(this).parents('table.budget-table');
            let vehicleId = $table.data('vehicle_id');
            let vehicleTitle = 0 < dayFocus ? $("#budget-car-title").val() : $table.data('vehicle_title');

            // 時刻の入力
            rentalDialog(vehicleId, vehicleTitle, oDay);
        });

        // レンタル予約貸渡日時フォーカスの設定
        $("#budget-start").focus(function () {
            changeFocus(0);
        });

        // レンタル予約返却日時フォーカスの設定
        $("#budget-end").focus(function () {
            changeFocus(1);
        });

    });

};

const mtsrcb_budget_admin = new BudgetAdmin(jQuery);
