<?php
/**
 * MTS Car Booking 車両データ(mtsrcb_vehicle)管理処理
 *
 * @Filename    VehicleAdmin.php
 * @Author      S.Hayashi
 * @Code        2018-07-03 Ver.1.0.0
 */
namespace MTSCarBookingTrial;

use MTSCarBookingTrial\models\Vehicle;
use MTSCarBookingTrial\views\VehicleAdminView;

class VehicleAdmin
{
    const PAGE_NAME = CarBooking::ADMIN_VEHICLE;

    private $view = null;
    private $oVehicle = null;       // 車両データ


    /**
     * Constructor init処理内
     */
    public function __construct()
    {
        // 管理画面 カスタム投稿タイプの処理登録
        //add_filter('manage_' . Config::MTSAB_ROOM . '_posts_columns', array($this, 'postsColumns'));
        //add_action('manage_' . Config::MTSAB_ROOM . '_posts_custom_column', array($this, 'postsCustomColumn'), 10, 2);

        // 車両編集のビューフック登録
        add_action ("add_meta_boxes_" . CustomPost::VEHICLE, array($this, 'loadView'));

        // 車両編集の入力と保存
        add_action('save_post', array($this, 'savePost'), 10, 3);

        // 車両編集(postmeta)の削除
        //add_action('before_delete_post', array($this, 'deletePost'));
    }

    /**
     * 編集処理準備
     */
    public function loadView($oPost)
    {
        $oVehicle = Vehicle::readVehicle($oPost);

        $this->view = new VehicleAdminView($oVehicle);
    }

    /**
     * 車両編集データ(postmeta)の編集入力保存処理
     */
    public function savePost($postId, $post, $update)
    {
        // カスタム投稿タイプ、操作権限を確認する
        if (get_post_type($postId) != CustomPost::VEHICLE || !current_user_can(CustomPost::CAPABILITY, $postId)) {
            return;
        }

        // nonceチェック
        if (!isset($_POST['vehicle_nonce']) || !wp_verify_nonce($_POST['vehicle_nonce'], self::PAGE_NAME)) {
            return;
        }

        // Auto saveの場合は保存しないようにする
        //if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        //    return;
        //}

        $oVehicle = Vehicle::readVehicle($post);

        // 編集データの入力
        $this->_input($oVehicle);

        $result = $oVehicle->savePostmeta();

        if (!$result) {
            die(sprintf('Error: %s on %s in %s.', $oVehicle->errCode, $oVehicle->errSub, get_class($this)));
        }
    }

    // 車両データの読み込み
    private function _input(Vehicle $oVehicle)
    {
        $post = stripslashes_deep($_POST['vehicle']);

        $data = $oVehicle->getData();

        foreach ($data as $column => &$val) {
            switch ($column) {
                case 'name':
                case 'number':
                case 'charge':
                case 'detail':
                case 'image':
                    $val = $post[$column];
                    break;
                case 'expiration':
                    $nen = Config::$gengoNen[$post[$column]['gengo']] + intval($post[$column]['year']) - 1;
                    //$nen -= 0 < $post[$column]['gengo'] ? 1 : 0;
                    $val = sprintf('%04d-%02d-%02d', $nen, $post[$column]['month'], $post[$column]['day']);
                    break;
            }
        }

        $oVehicle->setData($data);
    }

    /**
     * 車両データ(postmeta)の削除
     */
    public function deletePost($postId)
    {
        // カスタム投稿タイプ、操作権限を確認する
        if (get_post_type($postId) != CustomPost::CHARGE || !current_user_can(CustomPost::CAPABILITY, $postId)) {
            return;
        }

        $oVehicle = Vehicle::readVehicle($postId);

        $result = $oVehicle->deletePostmeta();
    }




    /**
     * 管理画面 予約品目一覧のカラムタイトル
     */
    public function postsColumns($columns)
    {
        $roomColumns =  array(
            'room_id' => 'ID',
            'room_type' => '形式',
            'nof_rooms' => '客室数',
            'capacity' => '定員',
            'under_repair' => '修繕中'
        );

        return array_merge(array_slice($columns, 0, 2), $roomColumns, array_slice($columns, 2));
    }

    /**
     * 管理画面 予約品目一覧のカラムデータ表示
     */
    public function postsCustomColumn($column, $roomId)
    {
        if (!isset($this->rooms[$roomId])) {
            $this->rooms[$roomId] = Room::readRoom($roomId);
        }

        switch ($column) {
            case 'room_id':
                echo $roomId;
                break;
            case 'room_type':
                echo $this->rooms[$roomId]->$column == 'private' ? '個室' : '相部屋';
                break;
            case 'nof_rooms':
            case 'capacity':
            case 'under_repair':
                echo $this->rooms[$roomId]->$column;
                break;
        }
    }

}
