<?php
/**
 * MTS Car Booking ショートコード組込処理
 *
 * @Filename    ShortCode.php
 * @Author      S.Hayashi
 * @Code        2019-01-16 Ver.1.0.0
 */

namespace MTSCarBookingTrial;

class ShortCode
{
    const RENTAL_BOX = 'rental_box';
    const RENTAL_CAR = 'rental_car';

    public static $shortCodes = array(
        self::RENTAL_BOX => 'RentalBox',
    );

    /**
     * ショートコードの登録
     */
    public static function addShortCode()
    {
        $oShortCode = new ShortCode;

        add_shortcode(self::RENTAL_BOX, array($oShortCode, 'rentalBox'));
        add_shortcode(self::RENTAL_CAR, array($oShortCode, 'rentalCar'));

        // ショートコード表示CSSの登録
        add_action('wp_enqueue_scripts', array($oShortCode, 'enqueueFront'));
    }

    /**
     * ショートコードRENTAL_BOX表示処理(注:header送信済み)
     */
    public function rentalBox($atts)
    {
        static $oRentalBox = null;

        if (!$oRentalBox) {
            $oRentalBox = new RentalBox;
        }

        return $oRentalBox->rendering($atts);
    }

    /**
     * ショートコードRENTAL_CAR表示処理(注:header送信済み)
     */
    public function rentalCar($atts)
    {
        static $oRentalCar = null;

        if (!$oRentalCar) {
            $oRentalCar = new RentalCar;
        }

        return $oRentalCar->rendering($atts);
    }

    /**
     * ショートコードの確認とCSSの追加
     */
    public function enqueueFront()
    {
        global $post;

        if (!$post) {
            return;
        }

        // ショートコード配列
        $codes = array_keys(self::$shortCodes);

        $pattern = get_shortcode_regex();

        if (preg_match_all("/$pattern/s", $post->post_content, $matches) && array_key_exists(2, $matches)) {
            // ショートコード表示のCSSファイル読込指定
            foreach ($codes as $shortCode) {
                if (in_array($shortCode, $matches[2])) {
                    $fname = "css/{$shortCode}";
                    // ユーザー定義ファイルを優先する
                    if (file_exists(sprintf('%s/%s_users.css', __DIR__, $fname))) {
                        $fname .= '_users';
                    }
                    wp_enqueue_style($shortCode, plugins_url("{$fname}.css", __FILE__));
                    break;
                }
            }
        }
    }

}
