<?php
/**
 * MTS Car Booking オプションデータ(mtsrcb_option)管理処理
 *
 * @Filename    OptionAdmin.php
 * @Author      S.Hayashi
 * @Code        2018-07-11 Ver.1.0.0
 */
namespace MTSCarBookingTrial;

use MTSCarBookingTrial\models\Option;
use MTSCarBookingTrial\views\OptionAdminView;

class OptionAdmin
{
    const PAGE_NAME = CarBooking::ADMIN_OPTION;

    // View
    private $view = null;
    private $oOption = null;        // 料金表データ

    /**
     * Constructor init処理内
     */
    public function __construct()
    {
        // 管理画面 カスタム投稿タイプの処理登録
        //add_filter('manage_' . Config::MTSAB_ROOM . '_posts_columns', array($this, 'postsColumns'));
        //add_action('manage_' . Config::MTSAB_ROOM . '_posts_custom_column', array($this, 'postsCustomColumn'), 10, 2);

        // オプション編集のビューフック登録
        add_action ("add_meta_boxes_" . CustomPost::OPTION, array($this, 'loadView'));

        // オプション編集の入力と保存
        add_action('save_post', array($this, 'savePost'), 10, 3);

        // 車両編集(postmeta)の削除
        //add_action('before_delete_post', array($this, 'deletePost'));
    }

    /**
     * 編集処理準備
     */
    public function loadView($oPost)
    {
        $oOption = Option::readOption($oPost);

        $this->view = new OptionAdminView($oOption);
    }

    /**
     * 車両編集データ(postmeta)の編集入力保存処理
     */
    public function savePost($postId, $post, $update)
    {
        // カスタム投稿タイプ、操作権限を確認する
        if (get_post_type($postId) != CustomPost::OPTION || !current_user_can(CustomPost::CAPABILITY, $postId)) {
            return;
        }

        // nonceチェック
        if (!isset($_POST['option_nonce']) || !wp_verify_nonce($_POST['option_nonce'], self::PAGE_NAME)) {
            return;
        }

        // Auto saveの場合は保存しないようにする
        //if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        //    return;
        //}

        $oOption = Option::readOption($post);

        // 編集データの入力
        $this->_input($oOption);

        $result = $oOption->savePostmeta();

        if (!$result) {
            die(sprintf('Error: %s on %s in %s.', $oOption->errCode, $oOption->errSub, get_class($this)));
        }
    }

    // オプションデータの読み込み
    private function _input(Option $oOption)
    {
        $post = stripslashes_deep($_POST['option']);

        $data = $oOption->getData();

        foreach ($data as $column => &$val) {
            switch ($column) {
                case 'name':
                case 'image':
                    $val = $post[$column];
                    break;
                case 'type':
                case 'inventory':
                case 'quantity':
                case 'calculation':
                case 'charge_id':
                    $val = (int) $post[$column];
                    break;
            }
        }

        $oOption->setData($data);
    }

    /**
     * オプションデータ(postmeta)の削除
     */
    public function deletePost($postId)
    {
        // カスタム投稿タイプ、操作権限を確認する
        if (get_post_type($postId) != CustomPost::OPTION || !current_user_can(CustomPost::CAPABILITY, $postId)) {
            return;
        }

        $oOption = Option::readOption($postId);

        $result = $oOption->deletePostmeta();
    }

}
