<?php
/**
 * MTS Car Booking 管理画面 各種設定処理モジュールのビュー
 *
 * @Filename    SettingAdminView.php
 * @Author      S.Hayashi
 * @Code        2018-06-28 Ver.1.0.0
 */
namespace MTSCarBookingTrial\views;

use MTSCarBookingTrial\SettingAdmin;
use MTSCarBookingTrial\models\MailTemplate;

class SettingAdminView
{
    const PAGE_NAME = SettingAdmin::PAGE_NAME;

    const CSS = '/css/mtsrcb-admin.css';

    // フォームヘルパー
    private $oHelper = null;

    private $tabNames = array(
        'reserve' => '予約条件',
        'form' => '予約フォーム',
        'payment' => '料金決済',
        'cancel' => 'キャンセル',
        'customer' => '連絡先',
    );

    private $sectionTitles = array(
        'reserve' => '予約受付の条件に関する設定',
        'form' => '予約フォームに関する設定',
        'payment' => '料金の計算や決済に関する設定',
        'cancel' => '予約のキャンセルに関する設定',
        'customer' => '予約申込者の入力項目の設定',
    );

    private $required = '(<span class="mts-required">*</span>)';

    // グループ名
    private $optionGroup = '';

    // カレントセクション
    private $section = '';
    private $sectionId;

    // 保存オプション名
    private $optionName;

    // 編集オブジェクト
    private $oSetting = null;

    public function __construct($groupName, $section, $optionName)
    {
        $this->optionGroup = $groupName;
        $this->section = $section;
        $this->optionName = $optionName;

        // JavaScript 組み込み登録の設定
        add_action('admin_enqueue_scripts', array($this, 'enqueueScripts'));

        $this->oHelper = new FormHelper;
    }

    /**
     * JavaScript,Style headタグ内のロード登録
     */
    public function enqueueScripts()
    {
        $dir = dirname(__FILE__);
        //wp_enqueue_script(self::PAGE_NAME, plugins_url(self::JS_FILE, $dir), array('jquery')); //, 'jquery-ui-dialog'));
        wp_enqueue_style(self::PAGE_NAME, plugins_url(self::CSS, $dir));

    }

    /**
     * 各種設定のセクション表示
     */
    public function settingForm($section, $object, $param1 = '', $param2 = '')
    {
        $title = $this->sectionTitles[$section];
        $submitTop = '保存する';

        $this->sectionId = sprintf('%s-%s', $this->optionGroup, $section);
        $this->oSetting = $object;

        // 当該セクションページの設定
        add_settings_section($this->sectionId, $title, array($this, "{$section}FieldsSetting"), self::PAGE_NAME);

        // タブのsection名を取得する
        $tabs = array_keys(SettingAdmin::$sectionKey);

        ?>
        <div class="wrap">
            <h2 class="nav-tab-wrapper">
                <?php foreach ($tabs as $tab) {
                    echo sprintf('<a class="nav-tab%s" href="%s">%s</a>',
                        ($tab == $section ? ' nav-tab-active' : ''),
                        admin_url(sprintf('admin.php?page=%s&amp;section=%s', self::PAGE_NAME, $tab)),
                        $this->tabNames[$tab]);
                } ?>
            </h2>
            <?php settings_errors() ?>

            <form method="post" action="options.php">
                <?php
                    settings_fields($this->optionGroup);
                    do_settings_sections($this->optionGroup);
                    submit_button($submitTop);
                ?>

                <input type="hidden" name="section" value="<?php echo $section ?>">
                <input id="mtsbe-nonce" type="hidden" value="<?php echo wp_create_nonce(self::PAGE_NAME) ?>">
            </form>

            <?php /* if ($section == 'email') echo "<p>{$this->required}は必須入力項目です。</p>"; */ ?>
        </div>

        <?php
    }

    // 入力項目の説明
    private function description($description)
    {
        echo sprintf('<div class="mts-description">%s</div>', $description);
    }

    // 選択肢「必須・任意・不要」を戻す
    private function selectOption()
    {
        return array('不要', '任意', '必須');
    }

    /**
     * Section:reserve
     */
    public function reserveFieldsSetting()
    {
        $method = array($this, 'outReserveField');

        add_settings_field('reserve_accept', '予約受付公開', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'accept'));
        add_settings_field('reserve_months', 'カレンダー表示月数', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'months'));
        add_settings_field('reserve_open', '予約受付開始', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'open'));
        add_settings_field('reserve_close', '予約受付終了', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'close'));
        add_settings_field('reserve_limit', '貸与期間', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'limit'));
        add_settings_field('reserve_interval', 'インターバル時間', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'interval'));
        add_settings_field('reserve_opening', '開店時間', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'opening'));
        add_settings_field('reserve_closing', '閉店時間', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'closing'));
        add_settings_field('reserve_on_season', '営業開始日', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => "on_season"));
        add_settings_field('reserve_off_season', '営業終了日', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => "off_season"));
    }

    /**
     * Output Reserve Section Fields
     */
    public function outReserveField($arg)
    {
        $item = $arg['label_for'];
        $id = sprintf('form_%s', $item);

        switch ($item) {
            case 'accept':
                echo $this->oHelper->radioButton($id, '', "{$this->optionName}[{$item}]", FormHelper::$donot, $this->oSetting->$item);
                $this->description('予約の受付処理を公開します。');
                break;
            case 'months':
                echo $this->oHelper->textBox($id, 'mts-small-number', "{$this->optionName}[{$item}]", $this->oSetting->$item, 'カ月');
                $this->description('表示する予約カレンダーの月数を設定して下さい。');
                break;
            case 'open':
                echo $this->oHelper->textBox($id, 'mts-small-number', "{$this->optionName}[{$item}]", $this->oSetting->$item, '日前から');
                $this->description('貸渡日は、何日前から受け付けるか日数を設定して下さい。');
                break;
            case 'close':
                echo $this->oHelper->textBox($id, 'mts-small-number', "{$this->optionName}[{$item}]", $this->oSetting->$item, '日前まで');
                $this->description('貸渡日は、何日前まで予約を受け付けるか日数を設定して下さい。');
                break;
            case 'limit':
                echo $this->oHelper->textBox($id, 'mts-small-number', "{$this->optionName}[{$item}]", $this->oSetting->$item, '日間');
                $this->description('最長のレンタル期間を設定して下さい。');
                break;
            case 'interval':
                echo $this->oHelper->textBox($id, 'mts-small-number', "{$this->optionName}[{$item}]", $this->oSetting->$item, '分');
                $this->description('出発・返却時間選択時の分インターバルを設定して下さい。');
                break;
            case 'opening':
                echo $this->oHelper->selectTime($id, '', "{$this->optionName}[{$item}]", $this->oSetting->$item);
                $this->description('貸渡の開始時間を設定します。');
                break;
            case 'closing':
                echo $this->oHelper->selectTime($id, '', "{$this->optionName}[{$item}]", $this->oSetting->$item);
                $this->description('返却受付の終了時間を設定します。');
                break;
            case 'on_season':
                $md = $this->oSetting->$item != '' ? explode('-', $this->oSetting->$item) : array('', '');
                echo $this->oHelper->selectMonth($id, '', "{$this->optionName}[{$item}]", (int)$md[0]);
                echo $this->oHelper->selectDay($id, '', "{$this->optionName}[{$item}]", (int)$md[1]);
                $this->description('季節営業の場合の貸渡開始月日を設定します。');
                break;
            case 'off_season':
                $md = $this->oSetting->$item != '' ? explode('-', $this->oSetting->$item) : array('', '');
                echo $this->oHelper->selectMonth($id, '', "{$this->optionName}[{$item}]", (int)$md[0]);
                echo $this->oHelper->selectDay($id, '', "{$this->optionName}[{$item}]", (int)$md[1]);
                $this->description('季節営業の場合の返却受付終了月日を設定します。');
                break;
        }
    }

    /**
     * Section Fields:予約フォーム
     */
    public function formFieldsSetting()
    {
        $method = array($this, 'outFormField');

        add_settings_field('form_passport', 'パスポート画像送信', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'passport'));
        add_settings_field('form_license', '免許証画像送信', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'license'));
        add_settings_field('form_concent', '利用規約同意', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'concent'));
        add_settings_field('form_tos_url', '利用規約ページURL', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'tos_url'));
        add_settings_field('form_gdpr_url', 'GDPR説明ページURL', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => "gdpr_url"));
        add_settings_field('form_charge', '料金計算表示', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => "charge"));
        add_settings_field('form_payment', '決済処理', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => "payment"));
        add_settings_field('form_mail', '予約メール', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'mail'));
    }

    /**
     * Output form Section Fields
     */
    public function outFormField($arg)
    {
        $item = $arg['label_for'];
        $id = sprintf('form_%s', $item);

        switch ($item) {
            case "passport":
                echo $this->oHelper->selectBox("{$id}", "setting-select", "{$this->optionName}[{$item}]", $this->selectOption(), $this->oSetting->$item);
                $this->description('パスポートのキャプチャ画像が必要な場合は「必須」を選択して下さい。');
                break;
            case 'license':
                echo $this->oHelper->selectBox("{$id}", "setting-select", "{$this->optionName}[{$item}]", $this->selectOption(), $this->oSetting->$item);
                $this->description('免許証のキャプチャ画像が必要な場合は「必須」を選択して下さい。');
                break;
            case 'concent':
                echo $this->oHelper->selectBox("{$id}", "setting-select", "{$this->optionName}[{$item}]", $this->selectOption(), $this->oSetting->$item);
                $this->description('利用規約やGDPR対応説明に同意が必要な場合は「必須」を選択して下さい。');
                break;
            case 'tos_url':
                echo $this->oHelper->textBox($id, 'mts-fat', "{$this->optionName}[{$item}]", $this->oSetting->$item);
                $this->description('利用規約のページURLを設定して下さい。');
                break;
            case 'gdpr_url':
                echo $this->oHelper->textBox($id, 'mts-fat', "{$this->optionName}[{$item}]", $this->oSetting->$item);
                $this->description('GDPRに対応したプライバシーポリシーの説明ページURLを設定して下さい。');
                break;
            case 'charge':
                echo $this->oHelper->radioButton($id, '', "{$this->optionName}[{$item}]", FormHelper::$donot, $this->oSetting->$item);
                $this->description('料金の計算結果を確認画面で表示します。');
                break;
            case 'payment':
                echo $this->oHelper->selectBox("{$id}", "setting-select", "{$this->optionName}[{$item}]", $this->selectOption(), $this->oSetting->$item);
                //echo $this->oHelper->radioButton($id, '', "{$this->optionName}[{$item}]", FormHelper::$donot, $this->oForm->$item);
                $this->description('予約と同時に決済が必要な場合は「必須」を設定して下さい。');
                break;
            case 'mail':
                $mails = $this->_getMailList();
                echo $this->oHelper->selectBox($id, 'setting-select', "{$this->optionName}[{$item}]", $mails, $this->oSetting->$item);
                $this->description('Web予約の際自動送信するメール文テンプレートを選択して下さい。');
                break;
        }
    }

    /**
     * Section Fields:決済
     */
    public function paymentFieldsSetting()
    {
        $method = array($this, 'outPaymentField');

        add_settings_field('payment_currency', '通貨', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'currency'));
        add_settings_field('payment_tax', '消費税', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'tax'));
        add_settings_field('payment_consumption', '計算方法', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'consumption'));
        add_settings_field('payment_clealance', '決済機能利用', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => "clearance"));
        add_settings_field('payment_assigned', '決済受付開始', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'assigned'));
        add_settings_field('payment_term', '決済受付期間', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'term'));
        add_settings_field('payment_limit', '決済受付期限', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'limit'));
        add_settings_field('payment_mail', '決済受付メール', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'mail'));
    }

    /**
     * Output payment Section Fields
     */
    public function outPaymentField($arg)
    {
        $item = $arg['label_for'];
        $id = sprintf('payment_%s', $item);

        switch ($item) {
            case "currency":
                echo $this->oHelper->selectBox($id, 'setting-select', "{$this->optionName}[{$item}]", ParamAdmin::$currency, $this->oSetting->$item);
                $this->description('表示料金の通貨を選択して下さい。');
                break;
            case 'tax':
                echo $this->oHelper->textBox($id, 'mts-small-number', "{$this->optionName}[{$item}]", $this->oSetting->$item, '%');
                $this->description('消費税率を100分率で設定して下さい。');
                break;
            case 'consumption':
                echo $this->oHelper->selectBox($id, 'setting-select', "{$this->optionName}[{$item}]", ParamAdmin::$consumption, $this->oSetting->$item);
                $this->description('消費税を含めた料金計算の方法を選択して下さい。');
                break;
            case 'clearance':
                echo $this->oHelper->radioButton($id, '', "{$this->optionName}[{$item}]", FormHelper::$donot, $this->oSetting->$item);
                $this->description('決済機能が組み込まれていない場合は「しない」を設定して下さい。');
                break;
            case 'assigned':
                echo $this->oHelper->textBox($id, 'mts-small-number', "{$this->optionName}[{$item}]", $this->oSetting->$item, '日前');
                $this->description('0は予約直後から、それ以外は貸渡日の設定日数前から決済を受け付けます。');
                break;
            case 'term':
                echo $this->oHelper->textBox($id, 'mts-small-number', "{$this->optionName}[{$item}]", $this->oSetting->$item, '日');
                $this->description('決済を受け付ける期間を日数で設定して下さい。');
                break;
            case 'limit':
                echo $this->oHelper->textBox($id, 'mts-small-number', "{$this->optionName}[{$item}]", $this->oSetting->$item, '日前');
                $this->description('貸渡日の設定日数前まで決済を受け付けます。');
                break;
            case 'mail':
                $mails = $this->_getMailList();
                echo $this->oHelper->selectBox($id, 'setting-select', "{$this->optionName}[{$item}]", $mails, $this->oSetting->$item);
                $this->description('申込者が決済処理を実行したときのメール文テンプレートを選択して下さい。');
                break;
        }
    }

    /**
     * Section Fields:キャンセル
     */
    public function cancelFieldsSetting()
    {
        $method = array($this, 'outCancelField');

        add_settings_field('cancel_limit', '受付期限', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'limit'));
        add_settings_field('cancel_charge', '料金請求', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'charge'));
        add_settings_field('cancel_tax', '消費税計算', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'tax'));
        add_settings_field('cancel_mail', 'キャンセルメール', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'mail'));
    }

    /**
     * Output payment Section Fields
     */
    public function outCancelField($arg)
    {
        $item = $arg['label_for'];
        $id = sprintf('cancel_%s', $item);

        switch ($item) {
            case 'limit':
                echo $this->oHelper->selectBox($id, 'setting-select', "{$this->optionName}[{$item}]", ParamAdmin::$cancelLimit, $this->oSetting->$item);
                $this->description('キャンセル受付の有無、期限を設定して下さい。');
                break;
            case 'charge':
                echo $this->oHelper->radioButton($id, '', "{$this->optionName}[{$item}]", ParamAdmin::$cancelChargeType, $this->oSetting->$item);
                $this->description(('キャンセル料を設定する場合はConfig.phpファイルに料金表を設定して下さい。'));
                break;
            case 'tax':
                echo $this->oHelper->radioButton($id, '', "{$this->optionName}[{$item}]", FormHelper::$donot, $this->oSetting->$item);
                $this->description('消費税計算の設定、計算方法は料金決済に準拠します。');
                break;
            case 'mail':
                $mails = $this->_getMailList();
                echo $this->oHelper->selectBox($id, 'setting-select', "{$this->optionName}[{$item}]", $mails, $this->oSetting->$item);
                $this->description('キャンセルしたときのメール文テンプレートを選択して下さい。');
                break;
        }
    }

    private function _getMailList()
    {
        return array(0 => '送信しない') + MailTemplate::listMailTemplate();
    }

    /**
     * Section:customer
     */
    public function customerFieldsSetting()
    {
        $method = array($this, 'outCustomerField');

        add_settings_field('customer_company', '企業・団体名', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'company'));
        add_settings_field('customer_seimei', '姓名', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'seimei'));
        add_settings_field('customer_furigana', 'カナ', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'furigana'));
        add_settings_field('customer_email', 'メール', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'email'));
        add_settings_field('customer_email2', 'メール確認', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'email2'));
        add_settings_field('customer_postcode', '郵便番号', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'postcode'));
        add_settings_field('customer_jusho', '住所', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'jusho'));
        add_settings_field('customer_country', '国名', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => "country"));
        add_settings_field('customer_tel', '電話番号', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => "tel"));
        add_settings_field('customer_mobile', '携帯電話', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => "mobile"));
        add_settings_field('customer_gender', '性別', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'gender'));
        add_settings_field('customer_birthday', '誕生日', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'birthday'));
        add_settings_field('customer_key', '暗号化共通鍵', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'key'));
        add_settings_field('customer_zip_search', '郵便番号検索', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'zip_search'));
        add_settings_field('customer_api_key', '郵便番号検索APIキー', $method, self::PAGE_NAME, $this->sectionId, array('label_for' => 'api_key'));
    }

    /**
     * Section:customer fields
     */
    public function outCustomerField($arg)
    {
        $item = $arg['label_for'];
        $id = sprintf('customer_%s', $item);

        if ($item === 'key') {
            $sample = substr(base64_encode(openssl_random_pseudo_bytes(16)), 0, 16);
            echo $this->oHelper->textBox($id, 'mts-small', "{$this->optionName}[{$item}]", $this->oSetting->$item, " サンプル：{$sample}");
            $this->description('64文字以下の半角英数文字、変更すると変更前の保存データが復号できなくなります。');
        } elseif ($item === 'zip_search') {
            echo $this->oHelper->selectBox($id, 'setting-select', "{$this->optionName}[{$item}]", ParamAdmin::$postcodeApi, $this->oSetting->$item);
        } elseif ($item === "api_key") {
            echo $this->oHelper->textBox($id, 'mts-fat', "{$this->optionName}[{$item}]", $this->oSetting->$item);
            $this->description('Web APIを利用するためのアクセスキーを設定する。');
        } else {
            echo $this->oHelper->selectBox($id, "setting-select", "{$this->optionName}[{$item}]", $this->selectOption(), $this->oSetting->$item);
        }
    }

}