<?php
/**
 * MTS Car Booking 料金表マスタ(カスタム投稿タイプ)
 *
 * @Filename    Charge.php
 * @Author      S.Hayashi
 * @Code        2018-07-09 Ver.1.0.0
 */
namespace MTSCarBookingTrial\models;

use MTSCarBookingTrial\Config;
use MTSCarBookingTrial\CustomPost;

class MailTemplate
{

    public $postId = 0;
    public $oPost = null;

    private $templates = array();

    public $errCode = '';
    public $errSub = '';

    /**
     * メールテンプレートデータを取得する
     */
    public static function readMailTemplate($postId)
    {
        $oTemplate = new MailTemplate;

        if (is_numeric($postId)) {
            $oTemplate->oPost = get_post($postId);
        } else {
            $oTemplate->oPost = $postId;
        }

        if ($oTemplate->oPost) {
            $oTemplate->postId = $oTemplate->oPost->ID;
            foreach (Config::$languages as $lang => $title) {
                $oTemplate->templates[$lang] = Mail::readTemplate($oTemplate->postId, $lang);
            }
        }

        return $oTemplate;
    }

    /**
     * テンプレートデータを保存する
     */
    public function saveMailTemplate()
    {
        foreach ($this->templates as $lang => $oMail) {
            $data = $oMail->getData();

            if (!add_post_meta($this->postId, $oMail->metaKey, $data, true)) {
                $oldMail = Mail::readTemplate($this->postId, $lang);
                $oldData = $oldMail->getData();

                if ($oldData != $data) {
                    if (!update_post_meta($this->postId, $oMail->metaKey, $data)) {
                        return $this->_setError('FAILED_UPDATE_POSTMETA', $oMail->metaKey);
                    }
                }
            }
        }

        return true;
    }

    /**
     * テンプレートデータを削除する
     */
    public function deleteMailTemplate()
    {
        foreach ($this->templates as $lang => $oMail) {
            if (!delete_post_meta($this->postId, $oMail->metaKey)) {
                return $this->_setError('FAILED_DELETE_POSTMETA', $oMail->metaKey);
            }
        }

        return true;
    }

    // エラー終了
    private function _setError($errCode, $sub)
    {
        $this->errCode = $errCode;
        $this->errSub = $sub;

        return false;
    }

    /**
     * プロパティから読み出す
     */
    public function __get($key)
    {
        if ($key === 'templates') {
            return (object) $this->templates;
        }

        if (isset($this->$key)) {
            return $this->$key;
        }

        $trace = debug_backtrace();
        trigger_error(sprintf(
            "Undefined property: '%s&' in %s on line %d, E_USER_NOTICE",
            $key, $trace[0]['file'], $trace[0]['line']
        ));

        return null;
    }

    /**
     * プロパティをセットする
     */
    public function __set($key, $value)
    {
        return $this->$key = $value;
    }

    /**
     * メールのテンプレートタイトル名一覧を取得する
     */
    public static function listMailTemplate()
    {
        global $wpdb;

        $order = 'ASC';

        $sql = $wpdb->prepare(
            "SELECT ID,post_title "
            . "FROM {$wpdb->posts} "
            . "WHERE post_type=%s AND post_status=%s "
            . "ORDER BY menu_order {$order}", CustomPost::MAIL_TEMPLATE, 'publish');

        $data = $wpdb->get_results($sql, ARRAY_A);

        // 読み込みデータを一覧リストにして戻す
        $templates = array();

        if ($data) {
            foreach ($data as $template) {
                $templates[$template['ID']] = $template['post_title'];
            }
        }

        return $templates;
    }

}
