/**
 * MTS Car Booking レンタル料金管理
 *
 * @Filename    payment-admin.js
 * @Author      S.Hayashi
 * @Code        2018-11-23 Ver.1.0.0
 */
const PaymentAdmin = function($)
{
    $(document).ready(function ()
    {
        // 燃料代計算
        $("#fuel-cost-compute").click(function () {
            let fuelCost =
                (($("#odo-end").val() - $("#odo-start").val()) * $("#fuel-cost").val() / $("#fuel-mileage").val());

            // 小数点切り捨て
            let cent = 0 < mtsrcb_decimals ? Math.pow(10, mtsrcb_decimals) : 0;
            fuelCost = mtsrcb_decimals <= 0 ? Math.floor(fuelCost) : Math.floor(fuelCost * cent) / cent;

            let costStr = String(fuelCost).replace(/(\d)(?=(\d\d\d)+(?!\d))/g, '$1,');

            $("#fuel-charge").val(costStr);
        });

    });

};

const mtsrcb_payment_admin = new PaymentAdmin(jQuery);
