<?php
/**
 * MTS Car Booking レンタカーショートコード処理
 *
 * @Filename    RentalCar.php
 * @Author      S.Hayashi
 * @Code        2019-05-10 Ver.1.0.0
 */

namespace MTSCarBookingTrial;

use MTSCarBookingTrial\models\Vehicle;
use MTSCarBookingTrial\views\ParamAdmin;
use MTSCarBookingTrial\lang\Translation;

class RentalCar
{
    private $atts = array(
        'vid' => 0,
        'column' => '',
        'index' => '',
        'lang' => Config::LANG,
    );

    private $bookingUrl = '';

    private $vehicles = array();

    /**
     * Constructor
     */
    public function __construct()
    {
        // 予約カレンダー表示リンクURL
        $this->bookingUrl = get_permalink(get_page_by_path(CarBooking::BOOKING_PAGE));

        // 車両詳細表示項目
        $this->detail = array_keys(ParamAdmin::$vehicleDetail);
    }

    /**
     * レンタカーボックスを出力する
     */
    public function rendering($atts)
    {
        $param = shortcode_atts($this->atts, $atts);

        $vid = intval($param['vid']);

        if (isset($this->vehicles[$vid])) {
            $oVehicle = $this->vehicles[$vid];
        }

        else {
            $oVehicle = Vehicle::readVehicle($vid);
            if (0 < $oVehicle->postId) {
                $this->vehicles[$vid] = $oVehicle;
            } else {
                return 'NOT_FOUND_VEHICLE';
            }
        }

        $str = 'NO_DATA';

        switch ($param['column']) {
            case 'name':
                $str = $oVehicle->name->{$param['lang']};
                break;
            case 'image':
                $str = $oVehicle->image[$param['index']];
                break;
            case 'detail':
                $str = $oVehicle->detail->{$param['index']};
                break;

        }

        return $str;
    }

}
