<?php
/**
 * MTS Car Booking メールテンプレートデータ(mtsrcb_mail)管理処理
 *
 * @Filename    MailTemplateAdmin.php
 * @Author      S.Hayashi
 * @Code        2018-08-09 Ver.1.0.0
 */
namespace MTSCarBookingTrial;

use MTSCarBookingTrial\models\Mail;
use MTSCarBookingTrial\models\MailTemplate;
use MTSCarBookingTrial\views\MailTemplateAdminView;

class MailTemplateAdmin
{
    const PAGE_NAME = CarBooking::ADMIN_MAIL_TEMPLATE;
    const NONCE_NAME = 'mail_template_nonce';

    // View
    private $view = null;

    public $oTemplate = null;

    public $msgCode = '';
    public $msgSub = '';
    public $errflg = false;

    /**
     * Constructor
     */
    public function __construct()
    {
        // 管理画面 カスタム投稿タイプの処理登録
        //add_filter('manage_' . Config::MTSAB_ROOM . '_posts_columns', array($this, 'postsColumns'));
        //add_action('manage_' . Config::MTSAB_ROOM . '_posts_custom_column', array($this, 'postsCustomColumn'), 10, 2);

        // メールテンプレート編集ビューのフック登録
        add_action ("add_meta_boxes_" . CustomPost::MAIL_TEMPLATE, array($this, 'loadView'));

        // テンプレートデータの入力と保存
        add_action('save_post', array($this, 'savePost'), 10, 3);

        // テンプレートデータの削除
        add_action('before_delete_post', array($this, 'deletePost'));
    }

    /**
     * 編集処理準備
     */
    public function loadView($oPost)
    {
        $this->oTemplate = MailTemplate::readMailTemplate($oPost);

        $this->view = new MailTemplateAdminView($this);
    }

    /**
     * テンプレートデータ(postmeta)の入力保存処理
     */
    public function savePost($postId, $post, $update)
    {
        // カスタム投稿タイプ、操作権限を確認する
        if (get_post_type($postId) != CustomPost::MAIL_TEMPLATE || !current_user_can(CustomPost::CAPABILITY, $postId)) {
            return;
        }

        // nonceチェック
        if (!isset($_POST[self::NONCE_NAME]) || !wp_verify_nonce($_POST[self::NONCE_NAME], self::PAGE_NAME)) {
            return;
        }

        // Auto saveの場合は保存しないようにする
        //if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        //    return;
        //}

        $oTemplate = MailTemplate::readMailTemplate($post);

        // 編集データの入力
        $this->_input($oTemplate);

        if (!$oTemplate->saveMailTemplate()) {
            $this->_setError($oTemplate->errCode, $oTemplate->errSub);
        };

        $this->_msgCode = 'Saved Normally';

        return;
    }

    // メールテンプレートデータの読み込み
    private function _input(MailTemplate $oTemplate)
    {
        $post = stripslashes_deep($_POST['mail']);

        // 言語別テンプレートデータを読み込む
        foreach (Config::$languages as $lang => $title) {
            $oTemplate->templates->{$lang}->setTemplate($post[$lang]);
        }
    }

    /**
     * メタデータ(postmeta)の削除
     */
    public function deletePost($postId)
    {
        // カスタム投稿タイプ、操作権限を確認する
        if (get_post_type($postId) != CustomPost::MAIL_TEMPLATE || !current_user_can(CustomPost::CAPABILITY, $postId)) {
            return;
        }

        $oTemplate = MailTemplate::readMailTemplate($postId);

        $result = $oTemplate->deleteMailTemplate();
/*
        if (!$result) {
            die(sprintf('Error: %s on %s in %s.', $oCharge->errCode, $oCharge->errSub, get_class($this)));
        }
*/
    }

    // エラー終了
    private function _setError($errCode, $sub)
    {
        $this->msgCode = $errCode;
        $this->msgSub = $sub;

        return false;
    }

}
