<?php
/**
 * MTS Car Booking 管理画面パラメータ
 *
 * @Filename    ParamAdmin.php
 * @Author      S.Hayashi
 * @Code        2018-07-27 Ver.1.0.0
 */
namespace MTSCarBookingTrial\views;

class ParamAdmin
{

    // サポート言語
    public static $languages = array(
        'ja' => '日本語',
        'en' => '英語'
    );

    // 車両情報
    public static $vehicleDetail = array(
        'type' => '車種',
        'displacement' => '排気量',
        'capacity' => '定員',
        'door' => 'ドア',
        'luggage' => '荷室',
        'model' => '年式',
        'smoking' => '喫煙',
        'navi' => 'ナビ',
        'etc' => 'ETC',
    );

    // 油種
    public static $fuelType = array(
        'regular' => 'レギュラー',
        'super' => 'ハイオク',
        'light' => '軽油',
    );

    // 通貨
    public static $currency = array(
        'jpy' => '円',
        'usd' => 'USドル',
        'eur' => 'ユーロ',
    );

    // 消費税額計算
    public static $consumption = array(
        '0' => '利用しない',
        '-1' => '内税',
        '1' => '外税',
    );

    // 料金対象
    public static $chargeItem = array(
        'vehicle' => '車両',
        'option' => 'オプション',
    );

    // 計算方法
    public static $compMethod = array(
        0 => '定額',
        1 => '単価計算',
        2 => '表引き',
    );

    // レンタル期間単位
    public static $timeUnit = array(
        'hour' => '時間',
        'day' => '日間',
    );

    // 予約Status定義
    public static $statusType = array(
        -1 => 'キャンセル',
        0 => '予約申込',
        1 => '確認完了',
        2 => '連絡済',
    );

    // 決済
    public static $accounting = array(
        0 => '未',
        1 => '現金',
        2 => 'カード',
        3 => 'Web',
        4 => 'その他',
    );

    // キャンセル受付期限
    public static $cancelLimit = array(
        0 => '受付不可',
        1 => '1日前',
        2 => '2日前',
        3 => '3日前',
        4 => '4日前',
        5 => '5日前',
        6 => '6日前',
        7 => '7日前',
    );

    // キャンセル料金計算方法
    public static $cancelChargeType = array(
        0 => 'しない',
        1 => '100分率',
        2 => '固定金額',
    );

    // 郵便番号検索
    public static $postcodeApi = array(
        '0' => '利用しない',
        '1' => 'Google Geocoding',
        '2' => 'PostcodeJP',
    );

/*
    // カレンダー表示記号
    public static $marking = array(
        'closed' => 'ー',
        'full' => '×',
        'few' => '△',
        'booked' => '☆',
        'empty' => '○',
    );
*/

    // Singleton
    private static $instance = NULL;

    private $data = array();

    /**
     * インスタンス化
     */
    public static function getInstance()
    {
        if (empty(self::$instance)) {
            self::$instance = new Config;
        }

        return self::$instance;
    }

}