<?php
/**
 * MTS Car Booking カレンダーデータ
 *
 * @Filename    Calendar.php
 * @Author      S.Hayashi
 * @Code        2018-07-31 Ver.1.0.0
 */
namespace MTSCarBookingTrial\models;

class Calendar
{
    private $data = array(
        'startOfWeek' => 0,

        'todayTime' => 0,       // Unix Time
        'todayMonth' => 0,      // Unix Time
        'yearToday' => 0,       // 本日
        'monthToday' => 0,      // 本月

        'year' => 0,
        'month' => 0,
        'days' => 31,
        'yearTime' => 0,        // 当年
        'monthTime' => 0,       // 当月
        'dayTime' => 0,         // 当日
        'prevTime' => 0,        // 前月
        'nextTime' => 0,        // 翌月
        'prevPrev' => 0,        // 前々月
        'nextNext' => 0,        // 翌々月
        'linkLast' => 0,        // 前月リンク有効期限
        'linkFuture' => 0,      // 翌月リンク有効期限
    );

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->startOfWeek = get_option('start_of_week');

        $todayYmd = explode('-', date_i18n('Y-n-j'));
        $this->yearToday = (int) $todayYmd[0];
        $this->monthToday = (int) $todayYmd[1];
        $this->todayTime = mktime(0, 0, 0, $todayYmd[1], $todayYmd[2], $todayYmd[0]);
        $this->todayMonth = mktime(0, 0, 0, $todayYmd[1], 1, $todayYmd[0]);

        $this->linkLast = mktime(0, 0, 0, 1, 1, $todayYmd[0]);
        $this->linkFuture = mktime(0, 0, 0, 12, 1, $todayYmd[0]);
    }

    /**
     * カレンダー操作パラメータを設定する
     */
    public function setCalendar($dayTime, $period=0)
    {
        $ymd = explode('-', date_i18n('Y-m-d', $dayTime));
        $year = (int) $ymd[0];
        $month = (int) $ymd[1];
        $day = (int) $ymd[2];

        $this->yearTime = mktime(0, 0, 0, 1, 1, $year);
        $this->monthTime = mktime(0, 0, 0, $month, 1, $year);
        $this->dayTime = $dayTime;
        $this->year = $year;
        $this->month = $month;
        $this->days = (int) date('z', $this->monthTime);//($this->nextTime - $this->monthTime) / 86400;

        // 期間$period日間
        if (0 < $period) {
            $this->prevTime = mktime(0, 0, 0, $month, $day - $period, $year);
            $this->prevPrev = mktime(0, 0, 0, $month, $day - $period * 2, $year);
            $this->nextTime = mktime(0, 0, 0, $month, $day + $period, $year);
            $this->nextNext = mktime(0, 0, 0, $month, $day + $period * 2, $year);
        }
        // 期間１カ月
        else {
            $this->prevTime = mktime(0, 0, 0, $month - 1, 1, $year);
            $this->prevPrev = mktime(0, 0, 0, $month - 2, 1, $year);
            $this->nextTime = mktime(0, 0, 0, $month + 1, 1, $year);
            $this->nextNext = mktime(0, 0, 0, $month + 2, 1, $year);
        }
    }

    /**
     * 翌年1月1日のUnix Time
     */
    public function nextYearTime($yearTime)
    {
        $year = (int) date ('Y', $yearTime);

        return (int) mktime(0, 0, 0, 1, 1, $year + 1);
    }

    /**
     * プロパティから読み出す
     */
    public function __get($key)
    {
        if (array_key_exists($key, $this->data)) {
            return $this->data[$key];
        }

        if (isset($this->$key)) {
            return $this->$key;
        }

        $trace = debug_backtrace();
        trigger_error(sprintf(
            "Undefined property: '%s&' in %s on line %d, E_USER_NOTICE",
            $key, $trace[0]['file'], $trace[0]['line']
        ));

        return null;
    }

    /**
     * プロパティをセットする
     */
    public function __set($key, $value)
    {
        if (array_key_exists($key, $this->data)) {
            $this->data[$key] = $value;
        } else {
            $this->$key = $value;
        }

        return $value;
    }

}
