<?php
/**
 * MTS Car Booking 多言語対応翻訳データ
 *
 * @Filename    Translation.php
 * @Author      S.Hayashi
 * @Code        2018-08-30 Ver.1.0.0
 */
namespace MTSCarBookingTrial\lang;

class Translation
{
    // 日付フォーマット
    public static $dateFormat = array(
        'ja' => 'Y年n月j日 (D)',
        'en' => 'D jS M Y',
    );

    // 年月表示フォーマット
    public static $yearMonthFormat = array(
        'ja' => 'Y年n月',
        'en' => 'F Y',
    );

    // 時間表示フォーマット
    public static $timeFormat = array(
        'ja' => 'G時i分',
        'en' => 'G:i',
    );

    // 期間を示す矢印
    public static $pArrow = array(
        'ja' => '➤',
        'en' => '➤',
    );

    // リンク項目の矢印
    public static $lArrow = array(
        'ja' => '►',
        'en' => '►',
    );

    // 曜日
    public static $week = array(
        'ja' => array('日', '月', '火', '水', '木', '金', '土'),
        'en' => array('Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'),
    );

    // 月正式
    public static $monthF = array(
        'en' => array('January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'),
    );

    // 月省略
    public static $monthM = array(
        'en' => array('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'),
    );

    // リンク左矢印
    public static $leftArrow = array(
        'ja' => '＜',
        'en' => '<',
    );

    // リンク右矢印
    public static $rightArrow = array(
        'ja' => '＞',
        'en' => '>',
    );

    // 名前並び
    public static $nameLine = array(
        'ja' => array('sei', 'mei'),
        'en' => array('mei', 'sei'),
    );

    // 住所並び
    public static $addressLine = array(
        'ja' => array('pref', 'city', 'town', 'building'),
        'en' => array('building', 'town', 'city', 'pref'),
    );

    // 性別並び
    public static $genderLine = array(
        'ja' => array('male', 'female'),
        'en' => array('male', 'female'),
    );

    // 誕生日並び
    public static $dateLine = array(
        'ja' => array('year', 'month', 'day'),
        'en' => array('day', 'month', 'year'),
    );

    // 予約者入力項目タイトル
    public static $customer = array(
        'company' => array(     // 会社・団体名
            'ja' => '会社・団体名',
            'en' => 'Company Name',
        ),
        'sei' => array(         // 姓
            'ja' => '姓',
            'en' => 'Family Name',
        ),
        'mei' => array(         // 名
            'ja' => '名',
            'en' => 'First Name',
        ),
        'seimei' => array(
            'ja' => '姓名',
            'en' => 'Full Name',
        ),
        'sei_kana' => array(    // 姓読み
            'ja' => 'セイ',
            'en' => 'Family Name',
        ),
        'mei_kana' => array(    // 名読み
            'ja' => 'メイ',
            'en' => 'First Name',
        ),
        'furigana' => array(
            'ja' => 'フリガナ',
            'en' => 'Roman',
        ),
        'email' => array(       // Eメール
            'ja' => 'Eメール',
            'en' => 'E Mail',
        ),
        'email2' => array(      // Eメール確認
            'ja' => 'Eメール再入力',
            'en' => 'Re E Mail',
        ),
        'postcode' => array(    // 〒番号
            'ja' => '郵便番号',
            'en' => 'Postcode',
        ),
        'pref' => array(        // 都道府県名
            'ja' => '都道府県',
            'en' => 'Prefecture',
        ),
        'city' => array(        // 郡市区名
            'ja' => '郡市区',
            'en' => 'City',
        ),
        'town' =>array(         // 町村番地
            'ja' => '町村番地',
            'en' => 'Address',
        ),
        'building' => array(    // アパートビル号
            'ja' => '建物号室',
            'en' => 'Building Room No.',
        ),
        'jusho' => array(
            'ja' => '住所',
            'en' => 'Address',
        ),
        'country' => array(     // 国
            'ja' => '居住国',
            'en' => 'Country',
        ),
        'tel' => array(         // 電話番号(携帯番号かどちらか一方)
            'ja' => '電話番号',
            'en' => 'Phone Number',
        ),
        'mobile' => array(      // 携帯電話番号
            'ja' => '携帯番号',
            'en' => 'Mobile Number',
        ),
        'gender' => array(      // 性別
            'ja' => '性別',
            'en' => 'Gender'
        ),
        'male' => array(
            'ja' => '男性',
            'en' => 'Male',
        ),
        'female' => array(
            'ja' => '女性',
            'en' => 'Female',
        ),
        'birthday' => array(    // 誕生日
            'ja' => '生年月日',
            'en' => 'Birthday'
        ),
    );

    // 予約者入力項目説明他
    public static $cDescription = array(
        'company' => array(     // 会社・団体名
            'ja' => '',
            'en' => '',
        ),
        'sei' => array(         // 姓
            'ja' => '',
            'en' => '',
        ),
        'mei' => array(         // 名
            'ja' => '',
            'en' => '',
        ),
        'sei_kana' => array(    // 姓読み
            'ja' => '',
            'en' => '',
        ),
        'mei_kana' => array(    // 名読み
            'ja' => '',
            'en' => '',
        ),
        'email' => array(       // Eメール
            'ja' => '',
            'en' => '',
        ),
        'email2' => array(      // Eメール確認
            'ja' => '',
            'en' => 'Input Repeat For Checking.',
        ),
        'postcode' => array(    // 〒番号
            'ja' => '',
            'en' => '',
        ),
        'pref' => array(        // 都道府県名
            'ja' => '',
            'en' => 'Prefecture or State etc.',
        ),
        'city' => array(        // 郡市区名
            'ja' => '',
            'en' => '',
        ),
        'town' =>array(         // 町村番地
            'ja' => '',
            'en' => 'Town Block Street etc.',
        ),
        'building' => array(    // アパートビル号
            'ja' => '',
            'en' => 'Number Building Room etc.',
        ),
        'country' => array(     // 国
            'ja' => '',
            'en' => 'Residence',
        ),
        'tel' => array(         // 電話番号(携帯番号かどちらか一方)
            'ja' => '',
            'en' => '',
        ),
        'mobile' => array(      // 携帯電話番号
            'ja' => '',
            'en' => '',
        ),
        'gender' => array(      // 性別
            'ja' => '',
            'en' => ''
        ),
        'birthday' => array(    // 誕生日
            'ja' => '',
            'en' => ''
        ),
    );

    // 予約者フォームエラーメッセージ
    public static $cError = array(
        'ERROR_REQUIRED' => array(
            'ja' => '必須入力項目です。',
            'en' => 'Required Data.'
        ),
        'INVALID_POSTCODE' => array(
            'ja' => '数字、ハイフン以外の文字があります。',
            'en' => 'Alphabet, Number, Hyphen Are Available.',
        ),
        'INVALID_PHONE_NUMBER' => array(
            'ja' => '数字、ハイフン以外の文字があります。',
            'en' => 'Number, Hyphen Are Available.',
        ),
        'INVALID_EMAIL' => array(
            'ja' => 'メールアドレスの記述に誤りがあります。',
            'en' => 'Invalid Email Address.',
        ),
        'UNMATCHED_EMAIL' => array(
            'ja' => '再入力のメールアドレスが一致しません。',
            'en' => 'Not The Same Above.',
        ),
        'NO_NUMBER_PHONE' => array(
            'ja' => '電話番号または携帯電話番号のどちらか一方の入力が必要です。',
            'en' => 'Input Your Phone Or Mobile Number Either.'
        ),
    );

    // その他出力関係
    public static $others = array(
        'required' => array(
            'ja' => '(<span class="mts-required">*</span>)',
            'en' => '(<span class="mts-required">*</span>)',
        ),
    );



    // フロントエンド表示メッセージ
    public static $fMessage = array(
        'BOOKING_CLOSED' => array(
            'ja' => '現在予約の受け付けを中止しています。',
            'en' => 'Now Booking Closed.'
        ),
        'OUTSIDE_ACCEPTED' => array(
            'ja' => '予約受付期間外です。',
            'en' => 'Period Outside Not Accepted.',
        ),
        'OFF_SEASON_CLOSED' => array(
            'ja' => '営業期間外です。',
            'en' => 'Closed For Off Season.',
        ),
        'OUTSIDE_HOURS' => array(
            'ja' => '営業時間外は受け付けられません。',
            'en' => 'Outside Hours Not Accepted.',
        ),
        'CAR_NOT_FOUND' => array(
            'ja' => '未登録の車両IDが指定されました : %s',
            'en' => 'Not Registered Vehicle ID : %s',
        ),
        'SCHEDULE_NOT_DETERMINED' => array(
            'ja' => '営業カレンダーが未決定です。',
            'en' => 'Not Determined Shop Schedule.',
        ),
        'SHOP_CLOSED' => array(
            'ja' => '休業日はお申込みできません。',
            'en' => 'Not Accept On The Day Closed.',
        ),
        'TOO_LONG_DAYS' => array(
            'ja' => 'レンタル期間は%d日以内です。',
            'en' => 'Rental Available in %d Days.',
        ),
        'PAGE_NOT_FOUND' => array(
            'ja' => 'ページが見つかりません。',
            'en' => 'Page Not Found.',
        ),
        'CAR_BOOKED' => array(
            'ja' => '申込期間中に他の予約が含まれています。',
            'en' => 'Can Not Include Other Rented Days In Period.'
        ),
        'INVALID_CUSTOMER_INPUT' => array(
            'ja' => '連絡先の入力に誤りがあります。',
            'en' => 'Invalid Contact Data.',
        ),
        'IMAGE_NOT_UPLOAD' => array(
            'ja' => '画像がアップロードされてません : %s',
            'en' => 'Not Upload Image : %s',
        ),
        'IMAGE_UPLOAD_ERROR' => array(
            'ja' => '画像アップロードでエラーが発生しました : %s',
            'en' => 'Error Occured While Uploading : %s',
        ),
        'INVALID_IMAGE_TYPE' => array(
            'ja' => '画像の形式はjpeg,png,gif以外は無効です。',
            'en' => 'Invalid Image Type Except jpeg png gif.'
        ),
        'UPLOAD_ERR_NO_FILE' => array(
            'ja' => 'アップロード画像がありません。',
            'en' => 'No Upload Image File.'
        ),
        'TERMS_CHECK_MISSING' => array(
            'ja' => '規約の同意が必要です。',
            'en' => 'Missing Terms OF Booking Checking.',
        ),
        'ABORT_BOOKING' => array(
            'ja' => '予約処理を中止しました。',
            'en' => 'Abort Your Rent A Car Booking.',
        ),
        'CAR_BOOKED_ALREADY' => array(
            'ja' => '申込車両は予約済みです。',
            'en' => 'Vehicle Booked In Period Already.',
        ),
        'DATABASE_ERROR' => array(
            'ja' => 'DBアクセスでエラーが発生しました : %s',
            'en' => 'Fatal Error Occured Accessing DB : %s',
        ),
        'INVALID_OPERATION' => array(
            'ja' => '無効な操作です。',
            'en' => 'Invalid Operation.',
        ),
        'RENTAL_NOT_FOUND' => array(
            'ja' => '見つかりませんでした。',
            'en' => 'Reservation Not Found.'
        ),
        'NOT_INSTALLED_PAYMENT' => array(
            'ja' => '決済機能が組み込まれていません。',
            'en' => 'Not Installed Payment Program.',
        ),
        'PAYMENT_TREATED_ALREADY' => array(
            'ja' => 'お支払いは済みました。ありがとうございました。',
            'en' => 'You have been paid. Thank you.',
        ),
        'CANCEL_EXPIRATION' => array(
            'ja' => 'キャンセルの有効期限が切れました。',
            'en' => 'Cancellation Has Expired.'
        ),
        'END_OF_RESERVE' => array(
            'ja' => '作業を終了しました。',
            'en' => 'Quit Viewing Reservation',
        ),
        'OPERATION_EXPIRATION' => array(
            'ja' => 'フォーム送信の有効時間が切れました。',
            'en' => 'Form Operation Has Expired.',
        ),
        'CANCEL_TIME_BORDER' => array(
            'ja' => '日付が変わりました。',
            'en' => 'Date Change.'
        ),
        'TEMPLATE_NOT_FOUND' => array(
            'ja' => 'メールテンプレートが登録されていません : %s',
            'en' => 'Mail Template Not Found : %s',
        )
    );


    // レンタル予約フォーム
    public static $bForm = array(
        'ENTRY_START_DATE' => array(
            'ja' => '出発',
            'en' => 'Drive Start',
        ),
        'ENTRY_END_DATE' => array(
            'ja' => '返却',
            'en' => 'Drive End',
        ),
        'ENTRY_DATE_DESCRIPTION' => array(
            'ja' => '出発・返却日時をカレンダー上の日付をクリックして入力して下さい。',
            'en' => 'Click On The Calendar Date Below For Drive Start And End With Japan Standard Time.',
        ),
        'ENTRY_DATE_BUTTON' => array(
            'ja' => '申込む',
            'en' => 'Enter',
        ),
        'FORM_BOOKING_TITLE' => array(
            'ja' => '予約内容',
            'en' => 'Date And Car',
        ),
        'FORM_PERIOD_TITLE' => array(
            'ja' => '予約期間',
            'en' => 'Period Of Drive'
        ),
        'FORM_VEHICLE_TITLE' => array(
            'ja' => '申込車両',
            'en' => 'Booking Car',
        ),
        'FORM_OPTION_TITLE' => array(
            'ja' => 'オプション選択',
            'en' => 'Option Selection',
        ),
        'FORM_OPTION_UNNEED' => array(
            'ja' => 'いいえ',
            'en' => 'No',
        ),
        'FORM_OPTION_RENTAL' => array(
            'ja' => 'はい',
            'en' => 'Yes',
        ),
        'FORM_NOT_SELECTED' => array(
            'ja' => '選択なし',
            'en' => 'Selected Nothing',
        ),
        'FORM_APPLICANT_TITLE' => array(
            'ja' => '申込者連絡先',
            'en' => 'Applicant Contact',
        ),
        'FORM_REQUIRED_DESCRIPTION' => array(
            'ja' => '「(<span class="mts-required">*</span>)」は必須入力項目です。',
            'en' => '"(<span class="mts-required">*</span>)" represents input necessary.',
        ),
        'FORM_UPLOAD_TITLE' => array(
            'ja' => '画像アップロード',
            'en' => 'Upload Image',
        ),
        'FORM_PASSPORT' => array(
            'ja' => 'パスポート',
            'en' => 'Passport',
        ),
        'FORM_LICENSE' => array(
            'ja' => '免許証',
            'en' => 'License',
        ),
        'FORM_IMAGE_UPLOADED' => array(
            'ja' => '送信済み',
            'en' => 'Sended Already',
        ),
        'FORM_IMAGE_REGISTERD' => array(
            'ja' => '未登録',
            'en' => 'Unregisterd',
        ),
        'FORM_TERMS_OF_USE' => array(
            'ja' => '利用規約',
            'en' => 'Terms Of Service',
        ),
        'FORM_PRIVACY_POLICY' => array(
            'ja' => 'プライバシーポリシー',
            'en' => 'General Data Protection Regulation',
        ),
        'CONFIRMATION_AGREEMENT' => array(
            'ja' => 'すべての規約に同意します。',
            'en' => 'I Agree With Terms Of All.',
        ),
        'ABORT_RETURN' => array(
            'ja' => '予約開始ページへ戻る',
            'en' => 'Return To Booking Entry',
        ),
        'HOME_RETURN' => array(
            'ja' => 'トップページへ戻る',
            'en' => 'Return To Top Page',
        ),
        'FINISH_BOOKING_TITLE' => array(
            'ja' => '予約終了',
            'en' => 'End Of Booking',
        ),
        'FINISH_RESERVE_ID' => array(
            'ja' => '予約ID',
            'en' => 'Reserve ID',
        ),
        'THANKS_BOOKING' => array(
            'ja' => 'ご予約ありがとうございました。',
            'en' => 'Thank You For Booking Our Rental Car.',
        ),
        'RESERVE_CANCEL_TITLE' => array(
            'ja' => '予約のキャンセル',
            'en' => 'Cancellation Of Booking',
        ),
    );


    // スペックタイトル
    public static $tSpec = array(
        'SPEC_CAPACITY' => array(
            'ja' => '乗車定員',
            'en' => 'Passengers',
        ),
    );

    // フロントエンドボタントップ
    public static $fButton = array(
/*
        'ENTRY' => array(
            'ja' => '予約追加',
            'en' => 'Add',
        ),
*/
        'CANCEL' => array(
            'ja' => 'キャンセル',
            'en' => 'Cancel',
        ),
        'BACK' => array(
            'ja' => '戻る',
            'en' => 'Back',
        ),
        'REMOVE' => array(
            'ja' => '削除',
            'en' => 'Remove',
        ),
        'CHECK' => array(
            'ja' => '確認する',
            'en' => 'Checking',
        ),
        'ABORT' => array(
            'ja' => '中止する',
            'en' => 'Abort',
        ),
        'BOOKING' => array(
            'ja' => '予約する',
            'en' => 'Booking',
        ),
        'FINDING' => array(
            'ja' => '検索する',
            'en' => 'Find',
        ),
        'EDIT' => array(
            'ja' => '編集',
            'en' => 'Edit',
        ),
        'CHANGE' => array(
            'ja' => '変更する',
            'en' => 'Change',
        ),
        'SEND' => array(
            'ja' => '送信する',
            'en' => 'Send',
        ),
        'QUIT' => array(
            'ja' => '終了する',
            'en' => 'Quit',
        ),
        'PAY' => array(
            'ja' => 'お支払い',
            'en' => 'Pay',
        ),
        'MAKE' => array(
            'ja' => '実行する',
            'en' => 'Make',
        ),
        'PRINT' => array(
            'ja' => 'このページを印刷',
            'en' => 'Print This Page',
        )
    );

    // 料金表示
    public static $fCharge = array(
        'CHARGE_TITLE' => array(
            'ja' => '請求料金',
            'en' => 'Charge',
        ),
        'SUBTOTAL' => array(
            'ja' => '合計',
            'en' => 'Subtotal',
        ),
        'TAX' => array(
            'ja' => '消費税',
            'en' => 'Tax',
        ),
        'RATE' => array(
            'ja' => '%d%%',
            'en' => '%d%%',
        ),
        'INCLUSIVE' => array(
            'ja' => '(内税)',
            'en' => '(Inclusive)',
        ),
        'EXCLUSIVE' => array(
            'ja' => '(外税)',
            'en' => '(Exclusive)',
        ),
        'TOTAL' => array(
            'ja' => '総合計',
            'en' => 'Total',
        ),
        'CANCEL_TOTAL' => array(
            'ja' => '合計',
            'en' => 'Total',
        ),
        'CURRENCY' => array(
            'ja' => '通貨',
            'en' => 'Currency',
        ),
        'JPY' => array(
            'ja' => '円',
            'en' => 'JP Yen',
        ),
        'USD' => array(
            'ja' => 'USドル',
            'en' => 'US Dollar',
        ),
        'EUR' => array(
            'ja' => 'ユーロ',
            'en' => 'Euro',
        ),
        'PAYMENT_TITLE' => array(
            'ja' => 'お支払い',
            'en' => 'Payment',
        ),
        'PAYMENT_STATE' => array(
            'ja' => '状態',
            'en' => 'State',
        ),
        'PAYMENT_UNPAID' => array(
            'ja' => '受付中',
            'en' => 'Acceptance',
        ),
        'PAYMENT_PAID' => array(
            'ja' => '済み',
            'en' => 'Paid',
        ),
        'PAYMENT_PERIOD' => array(
            'ja' => '期間',
            'en' => 'Period'
        ),

    );

    // 料金表示フォーマット
    public static $fCurrency = array(
        'ja' => '%d',
        'en' => '%01.2f',
    );



    // 予約確認ページ
    public static $rForm = array(
        'FIND_DESCRIPTION' => array(
            'ja' => '予約IDとメールアドレスを入力して検索してください。',
            'en' => 'Search Your Reservation With Reserve ID And Mail Address.',
        ),
        'RESERVE_ID' => array(
            'ja' => '予約ID',
            'en' => 'Reserve ID',
        ),
        'RESERVE_EMAIL' => array(
            'ja' => 'メールアドレス',
            'en' => 'E-Mail Address',
        ),
        'RESERVE_ID_DESCRIPTION' => array(
            'ja' => '',
            'en' => '',
        ),
        'RESERVE_EMAIL_DESCRIPTION' => array(
            'ja' => '',
            'en' => '',
        ),

        'RESERVE_OPTION_TITLE' => array(
            'ja' => '選択オプション',
            'en' => 'Selected Options',
        ),

        'RESERVE_CANCEL_TITLE' => array(
            'ja' => '予約キャンセルの確認',
            'en' => 'Cancellation Of Rental Reservation',
        ),
        'CANCEL_CHARGE_TITLE' => array(
            'ja' => 'キャンセル料金',
            'en' => 'Charge Of Cancellation',
        ),
        'CANCEL_CHARGE_MESSAGE' => array(
            'ja' => '以下のキャンセル料金が発生します。',
            'en' => 'Cancellation Needs Payment Following Cost.',
        ),
        'CANCEL_COST_TITLE' => array(
            'ja' => 'キャンセル料',
            'en' => 'Cancellation Cost',
        ),

    );






    // 予約変更フォーム
    public static $aReserved = array(
        'RESERVED_BOOKING_TITLE' => array(
            'ja' => '予約内容',
            'en' => 'Bookings',
        ),
        'RESERVED_CUSTOMER_TITLE' => array(
            'ja' => '申込者連絡先',
            'en' => 'Contact Data',
        ),
        'RESERVED_CUSTOMER_EDIT' => array(
            'ja' => '連絡先の変更',
            'en' => 'Change Contact Data',
        ),
        'RESERVED_PAY_DEFAULT' => array(
            'ja' => 'お支払いは宿泊時にご精算下さい。',
            'en' => 'Please pay at visiting our hotel.',
        ),
        'RESERVED_PAY_PREPARATION' => array(
            'ja' => 'お支払い受付準備中につき暫くお待ち下さい。',
            'en' => 'Now in preparation for payment, thank you.'
        ),
        'RESERVED_PAY_INFO' => array(
            'ja' => 'お支払いは%sから%sまでとなります。',
            'en' => 'Your charge accepts from %s untill %s.',
        ),
        'RESERVED_PAY_NOTE' => array(
            'ja' => '期日までにお支払いが確認できない場合は、予約を取り消しさせていただきます。',
            'en' => 'If we can\'t accept the payment until expire date, your booking will be canceled.',
        ),
        'RESERVED_PAID' => array(
            'ja' => 'お支払いは済みました。ありがとうございました。',
            'en' => 'You have been paid. Thank you.',
        ),
    );

    // クッキーの利用
    public static $clearlySpecify = array(
        'USE_COOKIE' => array(
            'ja' => '',
            'en' => 'We use cookies to give you the best and most relevant experience and optimize our website functionality. By using our website you confirm your acceptance of these cookies. Please see our Privacy Policy to find out more about the cookies we use.',
        ),
        'GDPR' => array(
            'ja' => '',
            'en' => '',
        ),
    );

    // 予約終了メッセージ
    public static $bookingThanks = array(
        'ja' => 'ご予約ありがとうございます。<br>予約IDは%RESERVE_ID%です。',
        'en' => 'Thank you for booking.<br>BOOKING ID is %RESERVE_ID%.',
    );

    // キャンセル終了メッセージ
    public static $canceledThanks = array(
        'ja' => '予約をキャンセルしました。<br>予約IDは%RESERVE_ID%です。',
        'en' => 'Canceled your booking, thanks.<br>BOOKING ID is %RESERVE_ID%.',
    );


    // ショートコード用
    public static $shortCode = array(
        'REGULAR' => array(
            'ja' => 'レギュラー',
            'en' => 'Regular',
        ),
        'SUPER' => array(
            'ja' => 'プレミアム',
            'en' => 'Premium',
        ),
        'LIGHT' => array(
            'ja' => '軽油',
            'en' => 'Light Diesel',
        ),

    );

}