/**
 * MTS Car Booking 車両データ管理
 *
 * @Filename    vehicle-admin.js
 * @Author      S.Hayashi
 * @Code        2018-07-05 Ver.1.0.0
 */
const VehicleAdmin = function($)
{
/*
    // AJAXパラメータ
    var ajaxp = {
        'action': 'mtsab_ajax',
        'module': '',
        'method': '',
        'nonce': ''
    };

    // 宿泊者タイプデータ
    var typeData = {
        'id': '',
        'name' : {},
        'min': 0,
        'max': 0,
        'default': 0,
        'counting': 'yes',
        'note': {}
    };

    // 宿泊者タイプオブジェクト配列
    var guestTypes = [];

    // 編集対象タイプ
    var currentType = {};


    this.version = function () {
        alert($().jquery);
    };
*/
    /**
     * デフォルトの宿泊者タイプを読み込んで追加する
     */
/*
    this.addDefaultGuest = function (guestId) {
        // 入力項目の初期化
        currentType = typeData;
        setDialogItems();

        // ダイアログを開く
        guestTypeDialog('add', guestId);

        // サーバーから初期設定値を取得してダイアログボックスに設定する
        getDefaultGuest(guestId);

        // デフォルトボタンを無効化する
        $("#guest-type-button-" + guestId).prop('disabled', true);
    };

    var loadingIcon = function (segId, sw) {
        $("#" + segId).css('display', sw ? 'block' : 'none');
    };


    // 宿泊対象者の初期設定データを取得する
    var getDefaultGuest = function (guestId) {
        // AJAXパラメータ設定
        ajaxp.module = $("#guest-dialog-module").val();
        ajaxp.method = 'defaultGuest';
        ajaxp.nonce = $("#guest-dialog-nonce").val();
        ajaxp.guestId = guestId;

        // ローディングアイコン表示
        loadingIcon('type-loading-box', 1);

        // Ajax送信
        $.ajax({
            type: 'post',
            url: ajaxurl,
            data: ajaxp,
            dataType: 'json'
        })
            .done(function (result) {
                if (!result.result) {
                    alert(result.result === false ? result.html : 'Error');
                } else {
                    currentType = result.html;
                    setDialogItems();
                }

                // ローディングアイコン消去
                loadingIcon('type-loading-box', 0);
            })
            .fail(function (fail) {
                alert('異常終了しました。')

                // ローディングアイコン消去
                loadingIcon('type-loading-box', 0);
            });

    };

    // ダイアログボックス内の値をセットする
    var setDialogItems = function () {
        //$("#dialog-guest-id").val(currentType.id);
        $("#dialog-guest-name-ja").text(currentType.name.ja);
        $("#dialog-guest-min").val(currentType.min);
        $("#dialog-guest-max").val(currentType.max);
        $("#dialog-guest-default").val(currentType.default);

        if (currentType.counting == 'yes') {
            $("#dialog-guest-counting-yes").prop('checked', true);
        } else {
            $("#dialog-guest-counting-no").prop('checked', true);
        }

        // 言語別注意書き
        $.each(currentType.note, function (key, str) {
            $("#dialog-guest-note-" + key).val(str);
        });
    };

    // ダイアログデータを宿泊対象者データオブジェクトにして戻す
    var getDialogItems = function () {
        //currentType.id = $("#dialog-guest-id").val();
        currentType.min = parseInt($("#dialog-guest-min").val());
        currentType.max = parseInt($("#dialog-guest-max").val());
        currentType.default = parseInt($("#dialog-guest-default").val());
        currentType.counting = $("input[name='guest[counting]']:checked").val();

        // 言語別注意書き
        $.each(currentType.note, function (key, str) {
            currentType.note[key] = $("#dialog-guest-note-" + key).val();
        });
    };

    // 宿泊対象者の設定ダイアログ
    var guestTypeDialog = function (action, guestId) {
        // ダイアログのパラメータ
        var param = {
            'title': '宿泊対象者の設定',
            'width': 580,
            'dialogClass': 'wp-dialog',
            'modal': true,
            'autoOpen': false,
            'closeOnEscape': true,
            'buttons': [
                {
                    'text': action == 'add' ? '追加する' : '変更する',
                    'class': 'button-secondary',
                    'click': function () {
                        // ダイアログボックスをクローズする
                        $(this).dialog('close');

                        // ダイアログのデータを取得する
                        getDialogItems();

                        // HTMLにセットする
                        if (action == 'add') {
                            addGuest(currentType);
                        } else {
                            replaceGuest(currentType);
                        }
                    }
                },
                {
                    'text': 'キャンセル',
                    'class': 'button-secondary',
                    'click': function () {
                        // ダイアログボックスをクローズする
                        $(this).dialog('close');

                        // 追加キャンセルならデフォルトボタンを有効化する
                        if (action == 'add') {
                            $("#guest-type-button-" + guestId).prop('disabled', false);
                        }
                    }
                }
            ]
        };

        // ダイアログを表示する
        $("#guest-dialog").dialog(param).dialog('open');
    };

    // 宿泊対象者データの追加
    var addGuest = function (guestType) {
        $addUl = $("#guest-type-template").clone(); //.appendTo($("#type-list"));
        $addUl.css('display', '');
        $addUl.prop('id', 'guest-type-' + guestType.id);
        $addUl.find(".type-id").text(guestType.name.ja);
        $addUl.find(".type-min").text(guestType.min);
        $addUl.find(".type-max").text(guestType.max);
        $addUl.find(".type-default").text(guestType.default);
        $addUl.find(".type-counting").text(guestType.counting == 'yes' ? 'する' : 'しない');

        var i = $("#type-list ul").length;
        $addUl.find(".type-action").html(
            '<input type="button" value="編集" onclick="mtsab_room_admin.editGuest(\'' + guestType.id + '\')">'
            + '<input type="button" value="削除" onclick="mtsab_room_admin.removeGuest(\'' + guestType.id + '\')">'
        );

        // 対象者定義入力行を追加する
        $addUl.appendTo($("#type-list"));

        // データ配列に要素を追加する
        guestTypes.push($.extend(true, {}, currentType));
        //guestTypes[guestType.id] = $.extend(true, {}, currentType);

        // 宿泊対象者データをPOSTへセットする
        $("#room-guests").val(JSON.stringify(guestTypes));
    };

    // 対象者リストの宿泊対象者表示データを書き換える
    var replaceGuest = function (guestType)
    {
        $("#guest-type-" + guestType.id + " .type-min").text(guestType.min);
        $("#guest-type-" + guestType.id + " .type-max").text(guestType.max);
        $("#guest-type-" + guestType.id + " .type-default").text(guestType.default);
        $("#guest-type-" + guestType.id + " .type-counting").text(guestType.counting == 'yes' ? 'する' : 'しない');

        // 宿泊対象者データをPOSTへセットする
        $("#room-guests").val(JSON.stringify(guestTypes));
    };
*/
    /**
     * 宿泊対象者定義データを削除する
     */
/*
    this.removeGuest = function (guestId)
    {
        var idx = getTypeIndex(guestId);

        if (idx < 0) {
            return;
        }

        if (confirm('「' + guestTypes[idx].name.ja + '」をリストから削除します。')) {

            // データを削除
            guestTypes.splice(idx, 1);

            // HTMLを削除
            $("#guest-type-" + guestId).remove();

            // 追加ボタンを有効化する
            $("#guest-type-button-" + guestId).prop('disabled', false);

            // 宿泊対象者データをPOSTへセットする
            $("#room-guests").val(JSON.stringify(guestTypes));
        }
    };
*/
    /**
     * 宿泊対象者定義データを編集する
     */
/*
    this.editGuest = function (guestId)
    {
        var idx = getTypeIndex(guestId);

        if (idx < 0) {
            return;
        }

        // オブジェクト配列から当該タイプの参照をセットする
        currentType = guestTypes[idx];

        // ダイアログボックスにデータをセットする
        setDialogItems();

        // ダイアログを開く
        guestTypeDialog('edit', currentType.id);
    };

    // オブジェクト配列からguestIdのオブジェクトのインデックスを取得する
    var getTypeIndex = function (guestId)
    {
        var idx = -1;

        for (var i = 0; i < guestTypes.length; i++) {
            if (guestTypes[i].id == guestId) {
                idx = i;
                break;
            }
        }

        if (idx < 0) {
            alert('Not found: ' + guestId);
        }

        return idx;
    };
*/

    let uploader;
    let trno;

    this.select = function (idx)
    {
        trno = idx;

        if (uploader) {
            uploader.open();
            return false;
        }

        uploader = wp.media({
            title: '画像選択',
            library: {
                type: 'image'
            },
            button: {
                text: '決定する'
            },
            multiple: false
        });

        uploader.on('select', function() {
            const images = uploader.state().get('selection');
            const $tr = $("#vehicle-image tr").eq(trno);

            images.each(function (data) {
                $tr.find(".car-image").prop('src', data.attributes.url);
                $tr.find(".image-url").val(data.attributes.url);
                //$("#car-media-url").val(data.attributes.url);
                //$("#car-media-image").attr('src', data.attributes.url);
            });
        });

        uploader.open();
        return false;
    };

    this.clear = function (idx)
    {
        const $tr = $("#vehicle-image tr").eq(idx);
        $tr.find(".car-image").prop('src', '');
        $tr.find(".image-url").val('');
        return false;
    };



    $(document).ready(function ()
    {
/*
        let uploader;

        $("#car-media-select").on('click', function(e) {
            e.preventDefault();

            if (uploader) {
                uploader.open();
                return false;
            }

            uploader = wp.media({
                title: '画像選択',
                library: {
                    type: 'image'
                },
                button: {
                    text: '選択する'
                },
                multiple: false
            });

            uploader.on('select', function() {
                const images = uploader.state().get('selection');

                images.each(function (data) {
                    const url = data.attributes.url;
                    $("#car-media-url").val(url);
                    $("#car-media-image").attr('src', url);
                });
            });

            uploader.open();
        });
*/

/*
        // typeDataの注意書きに言語項目を追加する
        $.each(mtsab_langs, function(key, langName) {
            typeData.name[key] = '';
            typeData.note[key] = '';
        });

        // 宿泊対象者を取得する
        guestTypes = JSON.parse($("#room-guests").val());

        // 宿泊対象者の表示、追加ボタン無効化
        $.each(guestTypes, function(key, guestType) {
            $("#guest-type-button-" + guestType.id).prop('disabled', true);
        });
*/
    });

};

const mtsrcb_vehicle_admin = new VehicleAdmin(jQuery);
