/**
 * MTS Car Booking 料金データ管理
 *
 * @Filename    charge-admin.js
 * @Author      S.Hayashi
 * @Code        2018-07-10 Ver.1.0.0
 */
const ChargeAdmin = function($)
{
    // 料金表データ
    let charge = {'regular' : [], 'limited' : []};

    // 料金表データをソート
    let chargeSort = function(type)
    {
        charge[type].sort(function(a, b) {
            return a.time < b.time ? -1 : 1;
        });
    };

    // 表示時間
    let titleTime = function (time)
    {
        if (time < 60) {
            return time + '秒';
        } else if (time < 3600) {
            return time / 60 + '分';
        } else if (time <= 86400) {
            return time / 3600 + '時間';
        }

        return time / 86400 + '日';
/*
        if (hour < 24) {
            return hour + '時間';
        }

        return hour / 24 + '日';
*/
    };

    // 料金表を再表示
    let listCharge = function(type)
    {
        $chargeList = $("#charge-list-" + type + " tbody");
        $chargeList.find("tr").remove();

        for (let i = 0; i < charge[type].length; i++) {
            let $tr = $("#charge-list-template tr").clone();
            $tr.find(".charge-table-time").text(titleTime(charge[type][i].time));
            $tr.find(".charge-table-price").text(Number(charge[type][i].price).toLocaleString());
            $tr.find(".charge-table-action input").click(function() { mtsrcb_charge_admin.delCharge(type, i) });

            $chargeList.append($tr);
        }

        // 入力項目にセットする
        $("#charge-val-" + type).val(JSON.stringify(charge[type]));
    };

    /**
     * 料金データを追加
     */
    this.addCharge = function(type)
    {
        let opeid = "#charge-" + type;

        let time = parseInt($(opeid).find(".charge-time").val());
        let price = parseInt($(opeid).find(".charge-price").val());

        switch ($(opeid).find(".charge-time-unit").val()) {
            case 'day':
                time *= 86400;
                break;
            case 'hour':
                time *= 3600;
                break;
            case 'minute':
                time *= 60;
                break;
        }

        charge[type].push({'time':time, 'price':price});
        chargeSort(type);

        listCharge(type);
    };

    /**
     * 料金データを削除
     */
    this.delCharge = function(type, idx)
    {
        charge[type].splice(idx, 1);

        listCharge(type);
    };

    $(document).ready(function ()
    {
        // 料金単位の変更
        $("#charge-currency").change(function() {
            $(".charge-currency").text($(this).find('option:selected').text());
        });

        // 料金表テーブルの初期化
        charge['regular'] = JSON.parse($("#charge-val-regular").val());
        charge['limited'] = JSON.parse($("#charge-val-limited").val());

        listCharge('regular');
        listCharge('limited');
/*
        if (chargeStr) {
            chargeTable = JSON.parse(chargeStr);
            listCharge();
        }
*/
    });

};

const mtsrcb_charge_admin = new ChargeAdmin(jQuery);
