<?php
/**
 * MTS Car Booking 管理画面 各種設定処理モジュール
 *
 * @Filename    SettingAdmin.php
 * @Author      S.Hayashi
 * @Code        2018-06-28 Ver.1.0.0
 */
namespace MTSCarBookingTrial;

//use MTSBookingEx\models\Email;
//use MTSBookingEx\models\Article;
use MTSCarBookingTrial\views\SettingAdminView;
//use MTSCarBookingTrial\views\Strings;

class SettingAdmin
{
    const PAGE_NAME = CarBooking::ADMIN_SETTING;
    const GROUP_NAME = CarBooking::ADMIN_SETTING;

    const MODULE = 'setting';

    // 各種設定データと保存種別
    public static $sectionKey = array(
        'reserve' => 'no',
        'form' => 'no',
        'payment' => 'no',
        'cancel' => 'no',
        'customer' => 'no',
    );

/*
    // オプションデータ mtsbe-setting-email 初期値
    private static $optionEmail = array(
        'list' => array(),
        'input' => array(),
    );
*/
    // View
    private $view = null;

    // 処理対象セクション
    private $section = '';

    // オプション名
    private $optionName = '';

    // メッセージ・エラーメッセージ
    private $errflg = false;
    private $msgCode = '';
    private $msgSub = '';

    /**
     * Constructor
     */
    public function __construct($section)
    {
        // オプションデータのインストール
        //$this->_installSetting();

        // セクション名
        $this->section = $section;

        // オプション名
        $this->optionName = Config::getOptionName(self::MODULE, $section);

        //$this->view = new SettingAdminView(self::GROUP_NAME, $section, $this->optionName);

        // Setting API の初期設定
        register_setting(self::GROUP_NAME, $this->optionName, array($this, "{$section}Validation"));
    }

    /**
     * 各種設定データの初期設定とアップデート
     */
    public static function installSetting()
    {
        $update = false;

        foreach (self::$sectionKey as $section => $autoload) {
            $optionName = Config::getOptionName(self::MODULE, $section);
            $data = get_option(Config::getOptionName(self::MODULE, $section), false);
            $default = Config::getSetting($section);
            $newData = array();
            $updateSetting = false;

            // 新規設定
            if (empty($data)) {
                if ($data === false) {
                    add_option($optionName, (array) $default, '', $autoload);
                } else {
                    update_option($optionName, (array) $default);
                }
                $update = true;
            }

            // アップデート
            else {
                foreach ($default as $column => $val) {
                    if (!array_key_exists($column, $data)) {
                        $data[$column] = $val;
                        $updateSetting = true;
                    }
                    $newData[$column] = $data[$column];
                }
            }

            // データが変更されていれば保存する
            if ($updateSetting) {
                update_option ($optionName, $newData);
                $update = true;
            }
        }

        return $update;
    }

    /**
     * ページ表示のロードに合わせてビューを初期化する
     */
    public function initSettingView()
    {
        $this->view = new SettingAdminView(self::GROUP_NAME, $this->section, $this->optionName);
    }

    /**
     * 各種設定ページを表示する
     */
    public function setting()
    {
        $this->view->settingForm($this->section, Config::getSetting($this->section));
    }

    /**
     * 予約条件保存前処理
     */
    public function reserveValidation($input)
    {
        $data = Config::defaultSettings($this->section);

        foreach ($data as $key => $defVal) {
            switch ($key) {
                case 'opening':
                case 'closing':
                    $data->$key = intval($input[$key]['hour']) * 3600 + intval($input[$key]['minute']) * 60;
                    break;
                case 'on_season':
                case 'off_season':
                    if (1 <= $input[$key]['month'] && $input[$key]['month'] <= 12
                     && 1 <= $input[$key]['day'] && $input[$key]['day'] <= 31) {
                        $data->$key = sprintf('%02d-%02d', $input[$key]['month'], $input[$key]['day']);
                    }
                    break;
                default:
                    $data->$key = (int) $input[$key];
                    break;
            }
        }

        return (array) $data;
    }

    /**
     * 予約フォーム設定保存前処理
     */
    public function formValidation($input)
    {
        $data = Config::defaultSettings($this->section);

        foreach ($data as $key => $defVal) {
            switch ($key) {
                case 'passport':
                case 'license':
                case 'concent':
                case 'charge':
                case 'payment':
                case 'mail':
                    $data->$key = (int) $input[$key];
                    break;
                default:
                    $data->$key = $input[$key];
                    break;
            }
        }

        return (array) $data;
    }

    /**
     * 料金決済設定保存前処理
     */
    public function paymentValidation($input)
    {
        $data = Config::defaultSettings($this->section);

        foreach ($data as $key => $defVal) {
            switch ($key) {
                case 'currency':
                    $data->$key = $input[$key];
                    break;
                default:
                    $data->$key = (int) $input[$key];
                    break;
            }
        }

        return (array) $data;
    }

    /**
     * キャンセル設定処理
     */
    public function cancelValidation($input)
    {
        $data = Config::defaultSettings($this->section);

        foreach ($data as $key => $defVal) {
            switch ($key) {
                case 'limit':
                case 'charge':
                case 'tax':
                case 'mail':
                    $data->$key = (int) $input[$key];
                    break;
                default:
                    $data->rkey = $input[$key];
            }
        }

        return (array) $data;
    }

    /**
     * 予約申込者連絡先設定保存前処理
     */
    public function customerValidation($input)
    {
        $data = Config::defaultSettings($this->section);

        foreach ($data as $key => $defVal) {
            switch ($key) {
                case 'key':
                case 'api_key':
                    $data->$key = $input[$key];
                    break;
                default:
                    $data->$key = (int)$input[$key];
                    break;
            }
        }

        return (array) $data;
    }

}
