<?php
/**
 * MTS Car Booking 環境設定
 *
 * @Filename    Config.php
 * @Author      S.Hayashi
 * @Code        2018-06-27 Ver.1.0.0
 */
namespace MTSCarBookingTrial;

class Config
{
    const PLUGIN_ID = 'mts-car-booking-trial';
    const APPLICATION_ID = 'mts_car_booking-trial';
    const APPLICATION_NAME = 'MTSレンタカー予約システム体験版';

    const RELEASE_YEAR = 2019;
    const DOMAIN = 'mtsrcb';
    const LANG = 'ja';

    // 管理画面 メニュー操作権限
    const WORKING_CAPABILITY = 'edit_pages';
    const SETTING_CAPABILITY = 'install_plugins';

    // フロントエンドページ表示制御
    const ONLY_LOGON_USER = 0;

    // フォーム送信待ち有効時間(秒)
    const FORM_SEND_LIMIT = 3600;

    // 予約ID乱数桁数指定
    const RESERVE_ID_RANDOM = '';

    // オプションデータのシステム情報
    static $system = array(
        'application' => '',
        'version' => '',
        'table' => array(),
    );

    // 元号年
    public static $gengoNen = array(
        'seireki' => 1,
        'meiji' => 1868,
        'taisho' => 1912,
        'showa' => 1926,
        'heisei' => 1989,
        'reiwa' => 2019,
    );

    // サポート言語
    public static $languages = array(
        'ja' => '日本語',
        'en' => '英語'
    );

    // 通貨補助単位(小数点以下桁数)
    public static $currency = array(
        'jpy' => 0,
        'usd' => 2,
        'eur' => 2,
    );

    // カレンダー表示記号
    public static $marking = array(
        'closed' => 'ー',
        'booked' => '×',
        'available' => '○',
    );

    // キャンセル料の設定例(100分率) 日数 => 100分率
    public static $cancelCharge = array(
        1 => 1.0,
        2 => 0.5,
        3 => 0.1,
        //4 => 0,
    );

    // 決済(支払い)
    public static $accounting = array(
        'NOT_PAYMENT' => 0,
        'CASH' => 1,
        'CREDIT_CARD' => 2,
        'WEB' => 3,
        'OTHERS' => 4,
    );

    /**
     * wp_optionsへ保存するオプション名を戻す
     */
    public static function getOptionName($module, $section='')
    {
        if ($section) {
            return sprintf('%s_%s_%s', Config::DOMAIN, $module, $section);
        }

        return sprintf('%s_%s', Config::DOMAIN, $module);
    }

    /**
     * データベースのテーブル名を戻す
     */
    public static function getTableName($model)
    {
        global $wpdb;

        return sprintf('%s%s_%s', $wpdb->prefix, self::DOMAIN, $model);
    }

    /**
     * 各種設定データを取得する
     */
    public static function getSetting($section)
    {
        static $settings = array();

        if (isset($settings[$section])) {
            return $settings[$section];
        }

        $optionName = self::getOptionName('setting', $section);
        $optionData = get_option($optionName, array());
        $setting = self::defaultSettings($section);

        foreach ($setting as $item => $val) {
            if (isset($optionData[$item])) {
                $setting->$item = $optionData[$item];
            }
        }

        $settings[$section] = $setting;

        return $setting;
    }

    /**
     * 各種設定デフォルト値
     */
    public static function defaultSettings($section='')
    {
        static $settings = array(
            // 予約の条件
            'reserve' => array(
                'accept' => 0,          // 予約受付公開
                'months' => 1,          // カレンダー表示月数
                'open' => 60,           // 受付開始
                'close' => 1,           // 受付終了
                'limit' => 6,           // 貸与期間
                'interval' => 30,       // 時間選択分間隔
                'opening' => 28800,     // 開店時間(秒)午前8時
                'closing' => 61200,     // 閉店時間(秒)午後5時
                'on_season' => '',      // 営業開始日
                'off_season' => '',     // 営業終了日
            ),

            // 予約フォーム
            'form' => array(
                'passport' => 0,        // パスポート画像添付
                'license' => 0,         // 免許証画像添付
                'concent' => 2,         // 利用規約同意処理
                'tos_url' => '',        // 利用規約URL
                'gdpr_url' => '',       // EU一般データ保護寄贈に関する説明URL
                'charge' => 0,          // 計算料金表示
                'payment' => 0,         // 決済ボタン(0:不要, 1:任意 2:必須)
                'mail' => 0,            // 予約メールPost ID
            ),

            // 料金決済
            'payment' => array(
                'currency' => 'jpy',    // 通貨
                'tax' => 8,             // 消費税額(%)
                'consumption' => 1,     // 計算方法(外税)
                'clearance' => 0,       // 決済機能(無効)
                'assigned' => 0,        // 決済受付開始(0:予約当日 それ以外は貸与日前日数)
                'term' => 3,            // 決済受付期間(予約当日を含めての日数)
                'limit' => 1,           // 決済受付期限(貸与前日数)
                'mail' => 0,            // 決済受付メールPost ID
            ),

            'cancel' => array(
                'limit' => 0,           // キャンセル受付期限(Unix Time 0:受付不可)
                'charge' => 0,          // キャンセル料金有無(0:しない 1:固定料金 2:予約金100分率)
                'tax' => 0,             // 消費税計算(0:しない 1:する)
                'mail' => 0,            // キャンセルメールPost ID
            ),

            // 予約申込者の個人(連絡先)情報の入力指定(Customerクラスの定数参照)
            'customer' => array(
                'company' => 1,         // 会社・団体名
                'seimei' => 2,          // 姓名
                'furigana' => 1,        // フリガナ
                'email' => 2,           // Eメール
                'email2' => 2,          // Eメール確認
                'postcode' => 1,        // 郵便番号
                'jusho' => 1,           // 住所
                'country' => 1,         // 国名
                'tel' => 1,             // 電話番号
                'mobile' => 2,          // 携帯番号
                'gender' => 0,          // 性別
                'birthday' => 0,        // 誕生日
                'key' => 'in_64_chars', // 暗号化共通鍵(64バイト)
                'zip_search' => 0,      // 郵便番号検索利用
                'api_key' => '',        // APIキー
                //'google_key' => '',     // Google Geocoding Access KEY
            ),
        );

        $keys = array_keys($settings);

        if (in_array($section, $keys)) {
            return (object) $settings[$section];
        }

        return $keys;
    }

}